/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.core.CoreBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.EdtReplacementThread;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Task
implements TaskInfo,
Progressive {
    private static final Logger LOG = Logger.getInstance(Task.class);
    @Nullable
    protected final Project myProject;
    @Nullable
    protected final JComponent myParentComponent;
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    protected @NlsContexts.ProgressTitle @NotNull String myTitle;
    private final boolean myCanBeCancelled;
    @NlsContexts.Button
    private String myCancelText;
    private @NlsContexts.Tooltip String myCancelTooltipText;

    private Task(@Nullable Project project, @Nullable JComponent parentComponent, @NlsContexts.ProgressTitle @NotNull String title, boolean canBeCancelled) {
        if (title == null) {
            Task.$$$reportNull$$$0(0);
        }
        this.myCancelText = CoreBundle.message("button.cancel", new Object[0]);
        this.myCancelTooltipText = CoreBundle.message("button.cancel", new Object[0]);
        this.myProject = project;
        this.myParentComponent = parentComponent;
        this.myTitle = title;
        this.myCanBeCancelled = canBeCancelled;
    }

    public void onCancel() {
    }

    public void onSuccess() {
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void onError(@NotNull Exception error) {
        if (error == null) {
            Task.$$$reportNull$$$0(1);
        }
        LOG.error(error);
    }

    public void onThrowable(@NotNull Throwable error) {
        if (error == null) {
            Task.$$$reportNull$$$0(2);
        }
        if (error instanceof Exception) {
            this.onError((Exception)error);
        } else {
            LOG.error(error);
        }
    }

    public void onFinished() {
    }

    @NotNull
    public EdtReplacementThread whereToRunCallbacks() {
        EdtReplacementThread edtReplacementThread = EdtReplacementThread.EDT_WITH_IW;
        if (edtReplacementThread == null) {
            Task.$$$reportNull$$$0(3);
        }
        return edtReplacementThread;
    }

    public final Project getProject() {
        return this.myProject;
    }

    @Nullable
    public final JComponent getParentComponent() {
        return this.myParentComponent;
    }

    public final void queue() {
        ProgressManager.getInstance().run(this);
    }

    @Override
    @NlsContexts.ProgressTitle
    @NotNull
    public final String getTitle() {
        String string2 = this.myTitle;
        if (string2 == null) {
            Task.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @NotNull
    public final Task setTitle(@NlsContexts.ProgressTitle @NotNull String title) {
        if (title == null) {
            Task.$$$reportNull$$$0(5);
        }
        this.myTitle = title;
        Task task = this;
        if (task == null) {
            Task.$$$reportNull$$$0(6);
        }
        return task;
    }

    @Override
    public final String getCancelText() {
        return this.myCancelText;
    }

    @NotNull
    public final Task setCancelText(@NlsContexts.Button String cancelText) {
        this.myCancelText = cancelText;
        Task task = this;
        if (task == null) {
            Task.$$$reportNull$$$0(7);
        }
        return task;
    }

    @ApiStatus.Experimental
    @Nullable
    public Object getId() {
        return null;
    }

    @Nullable
    public NotificationInfo getNotificationInfo() {
        return null;
    }

    @Nullable
    public NotificationInfo notifyFinished() {
        return this.getNotificationInfo();
    }

    public boolean isHeadless() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    @NotNull
    public final Task setCancelTooltipText(@NlsContexts.Tooltip String cancelTooltipText) {
        this.myCancelTooltipText = cancelTooltipText;
        Task task = this;
        if (task == null) {
            Task.$$$reportNull$$$0(8);
        }
        return task;
    }

    @Override
    public final String getCancelTooltipText() {
        return this.myCancelTooltipText;
    }

    @Override
    public final boolean isCancellable() {
        return this.myCanBeCancelled;
    }

    public abstract boolean isModal();

    @NotNull
    public final Modal asModal() {
        if (this.isModal()) {
            Modal modal = (Modal)this;
            if (modal == null) {
                Task.$$$reportNull$$$0(9);
            }
            return modal;
        }
        throw new IllegalStateException("Not a modal task");
    }

    @NotNull
    public final Backgroundable asBackgroundable() {
        if (!this.isModal()) {
            Backgroundable backgroundable = (Backgroundable)this;
            if (backgroundable == null) {
                Task.$$$reportNull$$$0(10);
            }
            return backgroundable;
        }
        throw new IllegalStateException("Not a backgroundable task");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/Task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/Task";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "whereToRunCallbacks";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "setTitle";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "setCancelText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "setCancelTooltipText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "asModal";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "asBackgroundable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onError";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onThrowable";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setTitle";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class NotificationInfo {
        private final String myNotificationName;
        private final @NlsContexts.SystemNotificationTitle String myNotificationTitle;
        private final @NlsContexts.SystemNotificationText String myNotificationText;
        private final boolean myShowWhenFocused;

        public NotificationInfo(@NotNull String notificationName, @NotNull @NlsContexts.SystemNotificationTitle String notificationTitle, @NotNull @NlsContexts.SystemNotificationText String notificationText) {
            if (notificationName == null) {
                NotificationInfo.$$$reportNull$$$0(0);
            }
            if (notificationTitle == null) {
                NotificationInfo.$$$reportNull$$$0(1);
            }
            if (notificationText == null) {
                NotificationInfo.$$$reportNull$$$0(2);
            }
            this(notificationName, notificationTitle, notificationText, false);
        }

        public NotificationInfo(@NotNull String notificationName, @NotNull @NlsContexts.SystemNotificationTitle String notificationTitle, @NotNull @NlsContexts.SystemNotificationText String notificationText, boolean showWhenFocused) {
            if (notificationName == null) {
                NotificationInfo.$$$reportNull$$$0(3);
            }
            if (notificationTitle == null) {
                NotificationInfo.$$$reportNull$$$0(4);
            }
            if (notificationText == null) {
                NotificationInfo.$$$reportNull$$$0(5);
            }
            this.myNotificationName = notificationName;
            this.myNotificationTitle = notificationTitle;
            this.myNotificationText = notificationText;
            this.myShowWhenFocused = showWhenFocused;
        }

        @NotNull
        public String getNotificationName() {
            String string2 = this.myNotificationName;
            if (string2 == null) {
                NotificationInfo.$$$reportNull$$$0(6);
            }
            return string2;
        }

        @NotNull
        @NlsContexts.SystemNotificationTitle
        public String getNotificationTitle() {
            String string2 = this.myNotificationTitle;
            if (string2 == null) {
                NotificationInfo.$$$reportNull$$$0(7);
            }
            return string2;
        }

        @NotNull
        @NlsContexts.SystemNotificationText
        public String getNotificationText() {
            String string2 = this.myNotificationText;
            if (string2 == null) {
                NotificationInfo.$$$reportNull$$$0(8);
            }
            return string2;
        }

        public boolean isShowWhenFocused() {
            return this.myShowWhenFocused;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notificationName";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notificationTitle";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notificationText";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/progress/Task$NotificationInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/progress/Task$NotificationInfo";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNotificationName";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNotificationTitle";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNotificationText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class Modal
    extends Task {
        public Modal(@Nullable Project project, @NlsContexts.DialogTitle @NotNull String title, boolean canBeCancelled) {
            if (title == null) {
                Modal.$$$reportNull$$$0(0);
            }
            this(project, null, title, canBeCancelled);
        }

        public Modal(@Nullable Project project, @Nullable JComponent parentComponent, @NlsContexts.DialogTitle @NotNull String title, boolean canBeCancelled) {
            if (title == null) {
                Modal.$$$reportNull$$$0(1);
            }
            super(project, parentComponent, title, canBeCancelled);
        }

        @Override
        public final boolean isModal() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/progress/Task$Modal", "<init>"));
        }
    }

    public static abstract class Backgroundable
    extends Task
    implements PerformInBackgroundOption {
        @NotNull
        private final PerformInBackgroundOption myBackgroundOption;

        public Backgroundable(@Nullable Project project, @NlsContexts.ProgressTitle @NotNull String title) {
            if (title == null) {
                Backgroundable.$$$reportNull$$$0(0);
            }
            this(project, title, true);
        }

        public Backgroundable(@Nullable Project project, @NlsContexts.ProgressTitle @NotNull String title, boolean canBeCancelled) {
            if (title == null) {
                Backgroundable.$$$reportNull$$$0(1);
            }
            this(project, title, canBeCancelled, ALWAYS_BACKGROUND);
        }

        public Backgroundable(@Nullable Project project, @NlsContexts.ProgressTitle @NotNull String title, boolean canBeCancelled, @Nullable PerformInBackgroundOption backgroundOption) {
            if (title == null) {
                Backgroundable.$$$reportNull$$$0(2);
            }
            this(project, null, title, canBeCancelled, backgroundOption);
        }

        public Backgroundable(@Nullable Project project, @Nullable JComponent parentComponent, @NlsContexts.ProgressTitle @NotNull String title, boolean canBeCancelled, @Nullable PerformInBackgroundOption backgroundOption) {
            if (title == null) {
                Backgroundable.$$$reportNull$$$0(3);
            }
            super(project, parentComponent, title, canBeCancelled);
            this.myBackgroundOption = ObjectUtils.notNull(backgroundOption, ALWAYS_BACKGROUND);
            if (StringUtil.isEmptyOrSpaces(title)) {
                LOG.warn("Empty title for backgroundable task.", new Throwable());
            }
        }

        @Override
        public boolean shouldStartInBackground() {
            return this.myBackgroundOption.shouldStartInBackground();
        }

        @Override
        public void processSentToBackground() {
        }

        @Override
        public final boolean isModal() {
            return false;
        }

        public boolean isConditionalModal() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/progress/Task$Backgroundable", "<init>"));
        }
    }

    public static abstract class WithResult<T, E extends Exception>
    extends Modal {
        private volatile T myResult;
        private volatile Throwable myError;

        public WithResult(@Nullable Project project, @NlsContexts.DialogTitle @NotNull String title, boolean canBeCancelled) {
            if (title == null) {
                WithResult.$$$reportNull$$$0(0);
            }
            this(project, null, title, canBeCancelled);
        }

        public WithResult(@Nullable Project project, @Nullable JComponent component, @NlsContexts.DialogTitle @NotNull String title, boolean canBeCancelled) {
            if (title == null) {
                WithResult.$$$reportNull$$$0(1);
            }
            super(project, component, title, canBeCancelled);
        }

        @Override
        public final void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                WithResult.$$$reportNull$$$0(2);
            }
            try {
                this.myResult = this.compute(indicator);
            }
            catch (Throwable t2) {
                this.myError = t2;
            }
        }

        protected abstract T compute(@NotNull ProgressIndicator var1) throws E;

        public T getResult() throws E {
            Throwable t2 = this.myError;
            if (t2 != null) {
                ExceptionUtil.rethrowUnchecked(t2);
                throw (Exception)t2;
            }
            return this.myResult;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/progress/Task$WithResult";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class ConditionalModal
    extends Backgroundable {
        public ConditionalModal(@Nullable Project project, @NlsContexts.ProgressTitle @NotNull String title, boolean canBeCancelled, @NotNull PerformInBackgroundOption backgroundOption) {
            if (title == null) {
                ConditionalModal.$$$reportNull$$$0(0);
            }
            if (backgroundOption == null) {
                ConditionalModal.$$$reportNull$$$0(1);
            }
            this(project, null, title, canBeCancelled, backgroundOption);
        }

        public ConditionalModal(@Nullable Project project, @Nullable JComponent parentComponent, @NlsContexts.ProgressTitle @NotNull String title, boolean canBeCancelled, @NotNull PerformInBackgroundOption backgroundOption) {
            if (title == null) {
                ConditionalModal.$$$reportNull$$$0(2);
            }
            if (backgroundOption == null) {
                ConditionalModal.$$$reportNull$$$0(3);
            }
            super(project, parentComponent, title, canBeCancelled, backgroundOption);
        }

        @Override
        public final boolean isConditionalModal() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "backgroundOption";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/progress/Task$ConditionalModal";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

