/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.WrappedProgressIndicator;
import com.intellij.openapi.progress.impl.NonCancelableIndicator;
import com.intellij.openapi.progress.impl.ProgressRunner;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Java11Shim;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ConcurrentLongObjectMap;
import com.intellij.util.ui.EDT;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public class CoreProgressManager
extends ProgressManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(CoreProgressManager.class);
    static final int CHECK_CANCELED_DELAY_MILLIS = 10;
    private final AtomicInteger myUnsafeProgressCount = new AtomicInteger(0);
    private ScheduledFuture<?> myCheckCancelledFuture;
    private static final Map<ProgressIndicator, Set<Thread>> threadsUnderIndicator = new HashMap<ProgressIndicator, Set<Thread>>();
    private static final ConcurrentLongObjectMap<ProgressIndicator> currentIndicators = Java11Shim.Companion.getINSTANCE().createConcurrentLongObjectMap();
    private static final ConcurrentLongObjectMap<ProgressIndicator> threadTopLevelIndicators = Java11Shim.Companion.getINSTANCE().createConcurrentLongObjectMap();
    static final Set<Thread> threadsUnderCanceledIndicator = new HashSet<Thread>();
    @NotNull
    private static volatile CheckCanceledBehavior ourCheckCanceledBehavior = CheckCanceledBehavior.NONE;
    private static final Map<ProgressIndicator, AtomicInteger> nonStandardIndicators = new ConcurrentHashMap<ProgressIndicator, AtomicInteger>();
    private static final long MAX_PRIORITIZATION_NANOS = TimeUnit.SECONDS.toNanos(12L);
    private static final long MIN_PRIORITIZATION_NANOS = TimeUnit.MILLISECONDS.toNanos(5L);
    private final Set<Thread> myPrioritizedThreads = ConcurrentHashMap.newKeySet();
    private final AtomicInteger myDeprioritizations = new AtomicInteger();
    private volatile long myPrioritizingStartedNanos;

    private void startBackgroundNonStandardIndicatorsPing() {
        if (this.myCheckCancelledFuture != null) {
            return;
        }
        this.myCheckCancelledFuture = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> {
            for (ProgressIndicator indicator : nonStandardIndicators.keySet()) {
                try {
                    indicator.checkCanceled();
                }
                catch (ProcessCanceledException e) {
                    this.indicatorCanceled(indicator);
                }
            }
        }, 0L, 10L, TimeUnit.MILLISECONDS);
    }

    private void stopBackgroundNonStandardIndicatorsPing() {
        if (this.myCheckCancelledFuture != null) {
            this.myCheckCancelledFuture.cancel(true);
            this.myCheckCancelledFuture = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            this.stopBackgroundNonStandardIndicatorsPing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @ApiStatus.Internal
    @NotNull
    public static List<ProgressIndicator> getCurrentIndicators() {
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        // MONITORENTER : map2
        ArrayList<ProgressIndicator> arrayList = new ArrayList<ProgressIndicator>(threadsUnderIndicator.keySet());
        // MONITOREXIT : map2
        if (arrayList != null) return arrayList;
        CoreProgressManager.$$$reportNull$$$0(0);
        return arrayList;
    }

    @ApiStatus.Internal
    public boolean runCheckCanceledHooks(@Nullable ProgressIndicator indicator) {
        return false;
    }

    @ApiStatus.Internal
    protected boolean hasCheckCanceledHooks() {
        return false;
    }

    @Override
    protected void doCheckCanceled() throws ProcessCanceledException {
        if (this.isInNonCancelableSection()) {
            CheckCanceledBehavior behavior = ourCheckCanceledBehavior;
            if (behavior != CheckCanceledBehavior.NONE) {
                ProgressIndicator indicator = behavior == CheckCanceledBehavior.INDICATOR_PLUS_HOOKS ? this.getProgressIndicator() : null;
                this.runCheckCanceledHooks(indicator);
            }
            return;
        }
        Cancellation.checkCancelled();
        CheckCanceledBehavior behavior = ourCheckCanceledBehavior;
        if (behavior == CheckCanceledBehavior.NONE) {
            return;
        }
        if (behavior == CheckCanceledBehavior.INDICATOR_PLUS_HOOKS) {
            ProgressIndicator progress = this.getProgressIndicator();
            if (progress != null) {
                progress.checkCanceled();
            }
        } else {
            this.runCheckCanceledHooks(null);
        }
    }

    @Override
    public boolean hasProgressIndicator() {
        return this.getProgressIndicator() != null;
    }

    @Override
    public boolean hasUnsafeProgressIndicator() {
        return this.myUnsafeProgressCount.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasModalProgressIndicator() {
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            for (ProgressIndicator t2 : threadsUnderIndicator.keySet()) {
                if (!t2.isModal()) continue;
                return true;
            }
            return false;
        }
    }

    @Override
    public void runProcess(@NotNull Runnable process, @Nullable ProgressIndicator progress) {
        if (process == null) {
            CoreProgressManager.$$$reportNull$$$0(1);
        }
        if (progress != null) {
            CoreProgressManager.assertNoOtherThreadUnder(progress);
        }
        this.executeProcessUnderProgress(() -> {
            try {
                try {
                    if (progress != null && !progress.isRunning()) {
                        progress.start();
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                process.run();
            }
            finally {
                if (progress != null && progress.isRunning()) {
                    progress.stop();
                    if (progress instanceof ProgressIndicatorEx) {
                        ((ProgressIndicatorEx)progress).processFinish();
                    }
                }
            }
        }, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertNoOtherThreadUnder(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            CoreProgressManager.$$$reportNull$$$0(2);
        }
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            Thread other;
            Collection threads = threadsUnderIndicator.get(progress);
            Thread thread2 = other = threads == null || threads.isEmpty() ? null : (Thread)threads.iterator().next();
            if (other != null) {
                if (other == Thread.currentThread()) {
                    LOG.error("This thread is already running under this indicator, starting/stopping it here might be a data race");
                } else {
                    StringWriter stackTrace = new StringWriter();
                    ThreadDumper.dumpCallStack(other, (Writer)stackTrace, other.getStackTrace());
                    LOG.error("Other (" + other + ") is already running under this indicator (" + progress + ", " + progress.getClass() + "), starting/stopping it here might be a data race.\nConsider using com.intellij.openapi.progress.ProgressManager.executeProcessUnderProgress\nThe other stack trace:\n" + stackTrace);
                }
            }
        }
    }

    @Override
    public void executeNonCancelableSection(@NotNull Runnable runnable) {
        if (runnable == null) {
            CoreProgressManager.$$$reportNull$$$0(3);
        }
        this.computeInNonCancelableSection(() -> {
            runnable.run();
            return null;
        });
    }

    @Override
    public <T, E extends Exception> T computeInNonCancelableSection(@NotNull ThrowableComputable<T, E> computable) throws E {
        if (computable == null) {
            CoreProgressManager.$$$reportNull$$$0(4);
        }
        return (T)Cancellation.computeInNonCancelableSection(() -> this.computeUnderProgress(computable, NonCancelableIndicator.INSTANCE));
    }

    @Override
    public boolean runProcessWithProgressSynchronously(@NotNull Runnable process, @NotNull @NlsContexts.DialogTitle String progressTitle, boolean canBeCanceled, @Nullable Project project) {
        if (process == null) {
            CoreProgressManager.$$$reportNull$$$0(5);
        }
        if (progressTitle == null) {
            CoreProgressManager.$$$reportNull$$$0(6);
        }
        return this.runProcessWithProgressSynchronously(process, progressTitle, canBeCanceled, project, null);
    }

    @Override
    public <T, E extends Exception> T runProcessWithProgressSynchronously(final @NotNull ThrowableComputable<T, E> process, @NotNull @NlsContexts.DialogTitle String progressTitle, boolean canBeCanceled, @Nullable Project project) throws E {
        if (process == null) {
            CoreProgressManager.$$$reportNull$$$0(7);
        }
        if (progressTitle == null) {
            CoreProgressManager.$$$reportNull$$$0(8);
        }
        final AtomicReference result2 = new AtomicReference();
        final AtomicReference exception = new AtomicReference();
        this.runProcessWithProgressSynchronously(new Task.Modal(project, progressTitle, canBeCanceled){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    Object compute = process.compute();
                    result2.set(compute);
                }
                catch (Throwable t2) {
                    exception.set(t2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager$1", "run"));
            }
        });
        Throwable t2 = (Throwable)exception.get();
        if (t2 != null) {
            ExceptionUtil.rethrowUnchecked(t2);
            Exception e = (Exception)t2;
            throw e;
        }
        return (T)result2.get();
    }

    @Override
    public boolean runProcessWithProgressSynchronously(final @NotNull Runnable process, @NotNull @NlsContexts.DialogTitle String progressTitle, boolean canBeCanceled, @Nullable Project project, @Nullable JComponent parentComponent) {
        if (process == null) {
            CoreProgressManager.$$$reportNull$$$0(9);
        }
        if (progressTitle == null) {
            CoreProgressManager.$$$reportNull$$$0(10);
        }
        Task.Modal task = new Task.Modal(project, parentComponent, progressTitle, canBeCanceled){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                process.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager$2", "run"));
            }
        };
        return this.runProcessWithProgressSynchronously(task);
    }

    @Override
    public void runProcessWithProgressAsynchronously(@NotNull Project project, @NotNull @NlsContexts.ProgressTitle String progressTitle, final @NotNull Runnable process, final @Nullable Runnable successRunnable, final @Nullable Runnable canceledRunnable, @NotNull PerformInBackgroundOption option) {
        if (project == null) {
            CoreProgressManager.$$$reportNull$$$0(11);
        }
        if (progressTitle == null) {
            CoreProgressManager.$$$reportNull$$$0(12);
        }
        if (process == null) {
            CoreProgressManager.$$$reportNull$$$0(13);
        }
        if (option == null) {
            CoreProgressManager.$$$reportNull$$$0(14);
        }
        this.runProcessWithProgressAsynchronously(new Task.Backgroundable(project, progressTitle, true, option){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                process.run();
            }

            @Override
            public void onCancel() {
                if (canceledRunnable != null) {
                    canceledRunnable.run();
                }
            }

            @Override
            public void onSuccess() {
                if (successRunnable != null) {
                    successRunnable.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager$3", "run"));
            }
        });
    }

    @ApiStatus.Internal
    public static boolean shouldKeepTasksAsynchronousInHeadlessMode() {
        return SystemProperties.getBooleanProperty("intellij.progress.task.ignoreHeadless", false);
    }

    @ApiStatus.Internal
    public static boolean shouldKeepTasksAsynchronous() {
        Application application = ApplicationManager.getApplication();
        boolean isHeadless = application.isUnitTestMode() || application.isHeadlessEnvironment();
        return !isHeadless || CoreProgressManager.shouldKeepTasksAsynchronousInHeadlessMode();
    }

    @Override
    public void run(@NotNull Task task) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(15);
        }
        if (CoreProgressManager.isSynchronousHeadless(task)) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.runProcessWithProgressSynchronously(task);
            } else {
                this.runProcessWithProgressInCurrentThread(task, new EmptyProgressIndicator(), ModalityState.defaultModalityState());
            }
        } else if (task.isModal()) {
            this.runProcessWithProgressSynchronously(task.asModal());
        } else {
            Task.Backgroundable backgroundable = task.asBackgroundable();
            if (CoreProgressManager.isSynchronous(backgroundable)) {
                this.runProcessWithProgressSynchronously(backgroundable);
            } else {
                this.runAsynchronously(backgroundable);
            }
        }
    }

    private static boolean isSynchronousHeadless(Task task) {
        return task.isHeadless() && !CoreProgressManager.shouldKeepTasksAsynchronousInHeadlessMode();
    }

    private static boolean isSynchronous(Task.Backgroundable backgroundable) {
        return backgroundable.isConditionalModal() && !backgroundable.shouldStartInBackground();
    }

    private void runAsynchronously(@NotNull Task.Backgroundable task) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(16);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("CoreProgressManager#runAsynchronously, " + task, new Throwable());
        }
        if (EDT.isCurrentThreadEdt()) {
            this.runProcessWithProgressAsynchronously(task);
        } else {
            ApplicationManager.getApplication().invokeLater(() -> {
                Project project = task.getProject();
                if (project != null && project.isDisposed()) {
                    LOG.info("Task canceled because of project disposal: " + task);
                    this.finishTask(task, true, null);
                    return;
                }
                this.runProcessWithProgressAsynchronously(task);
            }, ModalityState.defaultModalityState());
        }
    }

    @NotNull
    protected ProgressIndicator createDefaultAsynchronousProgressIndicator(@NotNull Task.Backgroundable task) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(17);
        }
        return new EmptyProgressIndicator();
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(18);
        }
        Future<?> future = this.runProcessWithProgressAsynchronously(task, this.createDefaultAsynchronousProgressIndicator(task), null);
        if (future == null) {
            CoreProgressManager.$$$reportNull$$$0(19);
        }
        return future;
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task, @NotNull ProgressIndicator progressIndicator, @Nullable Runnable continuation) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(20);
        }
        if (progressIndicator == null) {
            CoreProgressManager.$$$reportNull$$$0(21);
        }
        Future<?> future = this.runProcessWithProgressAsynchronously(task, progressIndicator, continuation, progressIndicator.getModalityState());
        if (future == null) {
            CoreProgressManager.$$$reportNull$$$0(22);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected void startTask(@NotNull Task task, @NotNull ProgressIndicator indicator, @Nullable Runnable continuation) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(23);
        }
        if (indicator == null) {
            CoreProgressManager.$$$reportNull$$$0(24);
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Starting task '" + task + "' under progress: " + indicator, new Throwable());
            }
            task.run(indicator);
        }
        finally {
            try {
                if (indicator instanceof ProgressIndicatorEx) {
                    ((ProgressIndicatorEx)indicator).finish(task);
                }
            }
            finally {
                if (continuation != null) {
                    continuation.run();
                }
            }
        }
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task, @NotNull ProgressIndicator progressIndicator, @Nullable Runnable continuation, @NotNull ModalityState modalityState) {
        IndicatorDisposable indicatorDisposable;
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(25);
        }
        if (progressIndicator == null) {
            CoreProgressManager.$$$reportNull$$$0(26);
        }
        if (modalityState == null) {
            CoreProgressManager.$$$reportNull$$$0(27);
        }
        if (progressIndicator instanceof Disposable) {
            indicatorDisposable = new IndicatorDisposable(progressIndicator);
            Disposer.register(ApplicationManager.getApplication(), indicatorDisposable);
        } else {
            indicatorDisposable = null;
        }
        AtomicLong elapsed = new AtomicLong();
        CompletionStage completionStage = new ProgressRunner<Object>(progress -> {
            long start = System.currentTimeMillis();
            try {
                this.startTask(task, (ProgressIndicator)progress, continuation);
            }
            finally {
                elapsed.set(System.currentTimeMillis() - start);
            }
            return null;
        }).onThread(ProgressRunner.ThreadToUse.POOLED).withProgress(progressIndicator).submit().whenComplete(ClientId.decorateBiConsumer((result2, err) -> {
            if (!result2.isCanceled()) {
                this.notifyTaskFinished(task, elapsed.get());
            }
            ApplicationUtil.invokeLaterSomewhere(task.whereToRunCallbacks(), modalityState, () -> {
                this.finishTask(task, result2.isCanceled(), result2.getThrowable() instanceof ProcessCanceledException ? null : result2.getThrowable());
                if (indicatorDisposable != null) {
                    Disposer.dispose(indicatorDisposable);
                }
            });
        }));
        if (completionStage == null) {
            CoreProgressManager.$$$reportNull$$$0(28);
        }
        return completionStage;
    }

    void notifyTaskFinished(@NotNull Task.Backgroundable task, long elapsed) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(29);
        }
    }

    protected boolean runProcessWithProgressSynchronously(@NotNull Task task) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(30);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("CoreProgressManager#runProcessWithProgressSynchronously, " + task, new Throwable());
        }
        Ref exceptionRef = new Ref();
        Runnable taskContainer = () -> {
            try {
                this.startTask(task, this.getProgressIndicator(), null);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                exceptionRef.set(e);
            }
        };
        ApplicationEx application = ApplicationManagerEx.getApplicationEx();
        boolean result2 = application.runProcessWithProgressSynchronously(taskContainer, task.getTitle(), task.isCancellable(), CoreProgressManager.shouldEnterModalityState(task), task.getProject(), task.getParentComponent(), task.getCancelText());
        ApplicationUtil.invokeAndWaitSomewhere(task.whereToRunCallbacks(), application.getDefaultModalityState(), () -> this.finishTask(task, !result2, (Throwable)exceptionRef.get()));
        return result2;
    }

    @ApiStatus.Internal
    @VisibleForTesting
    public static boolean shouldEnterModalityState(@NotNull Task task) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(31);
        }
        return task.isModal() || EDT.isCurrentThreadEdt() && !CoreProgressManager.isSynchronousHeadless(task) && CoreProgressManager.isSynchronous(task.asBackgroundable());
    }

    public void runProcessWithProgressInCurrentThread(@NotNull Task task, @NotNull ProgressIndicator progressIndicator, @NotNull ModalityState modalityState) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(32);
        }
        if (progressIndicator == null) {
            CoreProgressManager.$$$reportNull$$$0(33);
        }
        if (modalityState == null) {
            CoreProgressManager.$$$reportNull$$$0(34);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("CoreProgressManager#runProcessWithProgressInCurrentThread, " + task, new Throwable());
        }
        if (progressIndicator instanceof Disposable) {
            Disposer.register(ApplicationManager.getApplication(), (Disposable)((Object)progressIndicator));
        }
        boolean processCanceled = false;
        Throwable exception = null;
        try {
            this.runProcess(() -> this.startTask(task, progressIndicator, null), progressIndicator);
        }
        catch (ProcessCanceledException e) {
            processCanceled = true;
        }
        catch (Throwable e) {
            exception = e;
        }
        boolean finalCanceled = processCanceled || progressIndicator.isCanceled();
        Throwable finalException = exception;
        ApplicationUtil.invokeAndWaitSomewhere(task.whereToRunCallbacks(), modalityState, () -> this.finishTask(task, finalCanceled, finalException));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishTask(@NotNull Task task, boolean canceled, @Nullable Throwable error) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(35);
        }
        try {
            if (error != null) {
                task.onThrowable(error);
            } else if (canceled) {
                task.onCancel();
            } else {
                task.onSuccess();
            }
        }
        finally {
            task.onFinished();
        }
    }

    @Override
    public void runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task, @NotNull ProgressIndicator progressIndicator) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(36);
        }
        if (progressIndicator == null) {
            CoreProgressManager.$$$reportNull$$$0(37);
        }
        this.runProcessWithProgressAsynchronously(task, progressIndicator, null);
    }

    @Override
    public ProgressIndicator getProgressIndicator() {
        return CoreProgressManager.getCurrentIndicator(Thread.currentThread());
    }

    @Override
    public void executeProcessUnderProgress(@NotNull Runnable process, ProgressIndicator progress) throws ProcessCanceledException {
        if (process == null) {
            CoreProgressManager.$$$reportNull$$$0(38);
        }
        this.computeUnderProgress(() -> {
            process.run();
            return null;
        }, progress);
    }

    @Override
    public boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action2, @Nullable ProgressIndicator indicator) {
        if (action2 == null) {
            CoreProgressManager.$$$reportNull$$$0(39);
        }
        ApplicationManager.getApplication().runReadAction(action2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V, E extends Throwable> V computeUnderProgress(@NotNull ThrowableComputable<V, E> process, ProgressIndicator progress) throws E {
        if (process == null) {
            CoreProgressManager.$$$reportNull$$$0(40);
        }
        if (progress == null) {
            this.myUnsafeProgressCount.incrementAndGet();
            try {
                V v = process.compute();
                return v;
            }
            finally {
                this.myUnsafeProgressCount.decrementAndGet();
            }
        }
        ProgressIndicator oldIndicator = this.getProgressIndicator();
        if (progress == oldIndicator) {
            return process.compute();
        }
        Thread currentThread = Thread.currentThread();
        long threadId = currentThread.getId();
        CoreProgressManager.setCurrentIndicator(threadId, progress);
        try {
            V v = this.registerIndicatorAndRun(progress, currentThread, oldIndicator, process);
            return v;
        }
        finally {
            CoreProgressManager.setCurrentIndicator(threadId, oldIndicator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V, E extends Throwable> V registerIndicatorAndRun(@NotNull ProgressIndicator indicator, @NotNull Thread currentThread, ProgressIndicator oldIndicator, @NotNull ThrowableComputable<V, E> process) throws E {
        Map<ProgressIndicator, Set<Thread>> map2;
        ProgressIndicator thisIndicator;
        if (indicator == null) {
            CoreProgressManager.$$$reportNull$$$0(41);
        }
        if (currentThread == null) {
            CoreProgressManager.$$$reportNull$$$0(42);
        }
        if (process == null) {
            CoreProgressManager.$$$reportNull$$$0(43);
        }
        ArrayList<Set> threadsUnderThisIndicator = new ArrayList<Set>();
        Map<ProgressIndicator, Set<Thread>> map3 = threadsUnderIndicator;
        synchronized (map3) {
            boolean oneOfTheIndicatorsIsCanceled = false;
            thisIndicator = indicator;
            while (thisIndicator != null) {
                Set underIndicator = threadsUnderIndicator.computeIfAbsent(thisIndicator, __ -> new HashSet());
                boolean alreadyUnder = !underIndicator.add(currentThread);
                threadsUnderThisIndicator.add(alreadyUnder ? null : underIndicator);
                boolean isStandard = thisIndicator instanceof StandardProgressIndicator;
                if (!isStandard) {
                    nonStandardIndicators.compute(thisIndicator, (__, count2) -> {
                        if (count2 == null) {
                            return new AtomicInteger(1);
                        }
                        count2.incrementAndGet();
                        return count2;
                    });
                    this.startBackgroundNonStandardIndicatorsPing();
                }
                oneOfTheIndicatorsIsCanceled = oneOfTheIndicatorsIsCanceled || thisIndicator.isCanceled();
                thisIndicator = thisIndicator instanceof WrappedProgressIndicator ? ((WrappedProgressIndicator)thisIndicator).getOriginalProgressIndicator() : null;
            }
            this.updateThreadUnderCanceledIndicator(currentThread, oneOfTheIndicatorsIsCanceled);
        }
        try {
            map3 = process.compute();
            map2 = threadsUnderIndicator;
        }
        catch (Throwable throwable) {
            Map<ProgressIndicator, Set<Thread>> map4 = threadsUnderIndicator;
            synchronized (map4) {
                ProgressIndicator thisIndicator2 = null;
                for (int i = 0; i < threadsUnderThisIndicator.size(); ++i) {
                    AtomicInteger newCount;
                    boolean isStandard;
                    boolean removed;
                    thisIndicator2 = i == 0 ? indicator : ((WrappedProgressIndicator)thisIndicator2).getOriginalProgressIndicator();
                    Set underIndicator = (Set)threadsUnderThisIndicator.get(i);
                    boolean bl = removed = underIndicator != null && underIndicator.remove(currentThread);
                    if (removed && underIndicator.isEmpty()) {
                        threadsUnderIndicator.remove(thisIndicator2);
                    }
                    if ((isStandard = thisIndicator2 instanceof StandardProgressIndicator) || (newCount = nonStandardIndicators.compute(thisIndicator2, (__, count2) -> {
                        if (count2 == null || count2.decrementAndGet() == 0) {
                            return null;
                        }
                        return count2;
                    })) != null) continue;
                    this.stopBackgroundNonStandardIndicatorsPing();
                }
                this.updateThreadUnderCanceledIndicator(currentThread, oldIndicator != null && oldIndicator.isCanceled());
            }
            throw throwable;
        }
        synchronized (map2) {
            thisIndicator = null;
            for (int i = 0; i < threadsUnderThisIndicator.size(); ++i) {
                AtomicInteger newCount;
                boolean isStandard;
                boolean removed;
                thisIndicator = i == 0 ? indicator : ((WrappedProgressIndicator)thisIndicator).getOriginalProgressIndicator();
                Set underIndicator = (Set)threadsUnderThisIndicator.get(i);
                boolean bl = removed = underIndicator != null && underIndicator.remove(currentThread);
                if (removed && underIndicator.isEmpty()) {
                    threadsUnderIndicator.remove(thisIndicator);
                }
                if ((isStandard = thisIndicator instanceof StandardProgressIndicator) || (newCount = nonStandardIndicators.compute(thisIndicator, (__, count2) -> {
                    if (count2 == null || count2.decrementAndGet() == 0) {
                        return null;
                    }
                    return count2;
                })) != null) continue;
                this.stopBackgroundNonStandardIndicatorsPing();
            }
            this.updateThreadUnderCanceledIndicator(currentThread, oldIndicator != null && oldIndicator.isCanceled());
        }
        return (V)map3;
    }

    private void updateThreadUnderCanceledIndicator(@NotNull Thread thread2, boolean underCanceledIndicator) {
        boolean changed;
        if (thread2 == null) {
            CoreProgressManager.$$$reportNull$$$0(44);
        }
        boolean bl = changed = underCanceledIndicator ? threadsUnderCanceledIndicator.add(thread2) : threadsUnderCanceledIndicator.remove(thread2);
        if (changed) {
            this.updateShouldCheckCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void updateShouldCheckCanceled() {
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            boolean hasCanceledIndicator;
            boolean bl = hasCanceledIndicator = !threadsUnderCanceledIndicator.isEmpty();
            ourCheckCanceledBehavior = !this.hasCheckCanceledHooks() && !hasCanceledIndicator ? CheckCanceledBehavior.NONE : (hasCanceledIndicator ? CheckCanceledBehavior.INDICATOR_PLUS_HOOKS : CheckCanceledBehavior.ONLY_HOOKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void indicatorCanceled(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            CoreProgressManager.$$$reportNull$$$0(45);
        }
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            Set<Thread> threads = threadsUnderIndicator.get(indicator);
            if (threads != null) {
                for (Thread thread2 : threads) {
                    boolean underCancelledIndicator = false;
                    ProgressIndicator currentIndicator = CoreProgressManager.getCurrentIndicator(thread2);
                    while (currentIndicator != null) {
                        if (currentIndicator == indicator) {
                            underCancelledIndicator = true;
                            break;
                        }
                        currentIndicator = currentIndicator instanceof WrappedProgressIndicator ? ((WrappedProgressIndicator)currentIndicator).getOriginalProgressIndicator() : null;
                    }
                    if (!underCancelledIndicator) continue;
                    threadsUnderCanceledIndicator.add(thread2);
                    this.updateShouldCheckCanceled();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public static boolean isCanceledThread(@NotNull Thread thread2) {
        if (thread2 == null) {
            CoreProgressManager.$$$reportNull$$$0(46);
        }
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            return threadsUnderCanceledIndicator.contains(thread2);
        }
    }

    @Override
    public boolean isInNonCancelableSection() {
        return Cancellation.isInNonCancelableSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Throwable> T computePrioritized(@NotNull ThrowableComputable<T, E> computable) throws E {
        boolean prioritize;
        if (computable == null) {
            CoreProgressManager.$$$reportNull$$$0(47);
        }
        Thread thread2 = Thread.currentThread();
        if (this.isCurrentThreadPrioritized()) {
            prioritize = false;
        } else {
            prioritize = true;
            if (this.myPrioritizedThreads.isEmpty()) {
                this.myPrioritizingStartedNanos = System.nanoTime();
            }
            this.changePrioritizing(() -> this.myPrioritizedThreads.add(thread2));
        }
        try {
            T t2 = computable.compute();
            return t2;
        }
        finally {
            if (prioritize) {
                this.changePrioritizing(() -> this.myPrioritizedThreads.remove(thread2));
            }
        }
    }

    private <T> T changePrioritizing(@NotNull Computable<? extends T> runnable) {
        boolean currentIsEmpty;
        if (runnable == null) {
            CoreProgressManager.$$$reportNull$$$0(48);
        }
        boolean prevIsEmpty = this.myDeprioritizations.get() > 0 || this.myPrioritizedThreads.isEmpty();
        T result2 = runnable.compute();
        boolean bl = currentIsEmpty = this.myDeprioritizations.get() > 0 || this.myPrioritizedThreads.isEmpty();
        if (prevIsEmpty && !currentIsEmpty) {
            this.prioritizingStarted();
        } else if (!prevIsEmpty && currentIsEmpty) {
            this.prioritizingFinished();
        }
        return result2;
    }

    protected void prioritizingStarted() {
    }

    protected void prioritizingFinished() {
    }

    @ApiStatus.Internal
    public boolean isCurrentThreadPrioritized() {
        return this.myPrioritizedThreads.contains(Thread.currentThread());
    }

    @ApiStatus.Internal
    public void suppressPrioritizing() {
        int newDeprioritizations = this.changePrioritizing(() -> this.myDeprioritizations.incrementAndGet());
        if (newDeprioritizations == 100 + ForkJoinPool.getCommonPoolParallelism() * 2) {
            Attachment attachment = new Attachment("threadDump.txt", ThreadDumper.dumpThreadsToString());
            attachment.setIncluded(true);
            LOG.error("A suspiciously high nesting of suppressPrioritizing, forgot to call restorePrioritizing?", attachment);
        }
    }

    @ApiStatus.Internal
    public void restorePrioritizing() {
        int newDeprioritizations = this.changePrioritizing(() -> this.myDeprioritizations.decrementAndGet());
        if (newDeprioritizations < 0) {
            this.changePrioritizing(() -> this.myDeprioritizations.getAndSet(0));
            LOG.error("Unmatched suppressPrioritizing/restorePrioritizing");
        }
    }

    protected boolean sleepIfNeededToGivePriorityToAnotherThread() {
        if (this.isDeprioritizationEnabled() && !this.isCurrentThreadEffectivelyPrioritized() && this.isLowPriorityReallyApplicable()) {
            LockSupport.parkNanos(1000000L);
            this.avoidBlockingPrioritizingThread();
            return true;
        }
        return false;
    }

    private boolean isCurrentThreadEffectivelyPrioritized() {
        if (this.myDeprioritizations.get() > 0) {
            return false;
        }
        return this.isCurrentThreadPrioritized();
    }

    private boolean isLowPriorityReallyApplicable() {
        long time = System.nanoTime() - this.myPrioritizingStartedNanos;
        if (time < MIN_PRIORITIZATION_NANOS) {
            return false;
        }
        if (this.avoidBlockingPrioritizingThread()) {
            return false;
        }
        if (EDT.isCurrentThreadEdt()) {
            return false;
        }
        if (time > MAX_PRIORITIZATION_NANOS) {
            this.stopAllPrioritization();
            return false;
        }
        return true;
    }

    private boolean avoidBlockingPrioritizingThread() {
        if (this.isAnyPrioritizedThreadBlocked()) {
            this.suppressPrioritizing();
            this.checkLaterThreadsAreUnblocked();
            return true;
        }
        return false;
    }

    private void checkLaterThreadsAreUnblocked() {
        try {
            AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> {
                if (this.isAnyPrioritizedThreadBlocked()) {
                    this.checkLaterThreadsAreUnblocked();
                } else {
                    this.restorePrioritizing();
                }
            }, 5L, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    private void stopAllPrioritization() {
        this.changePrioritizing(() -> {
            this.myPrioritizedThreads.clear();
            return null;
        });
    }

    private boolean isAnyPrioritizedThreadBlocked() {
        if (this.myDeprioritizations.get() > 0) {
            return false;
        }
        for (Thread thread2 : this.myPrioritizedThreads) {
            Thread.State state = thread2.getState();
            if (state != Thread.State.WAITING && state != Thread.State.TIMED_WAITING && state != Thread.State.BLOCKED) continue;
            return true;
        }
        return false;
    }

    private boolean isDeprioritizationEnabled() {
        return this.myDeprioritizations.get() < 1000000;
    }

    @TestOnly
    @ApiStatus.Internal
    public <T, E extends Throwable> T suppressAllDeprioritizationsDuringLongTestsExecutionIn(@NotNull ThrowableComputable<T, E> runnable) throws E {
        if (runnable == null) {
            CoreProgressManager.$$$reportNull$$$0(49);
        }
        this.myDeprioritizations.addAndGet(1000000);
        try {
            T t2 = runnable.compute();
            return t2;
        }
        finally {
            this.myDeprioritizations.addAndGet(-1000000);
        }
    }

    @NotNull
    public static ModalityState getCurrentThreadProgressModality() {
        ModalityState contextModality = ModalityKt.currentThreadContextModality();
        if (contextModality != null) {
            ModalityState modalityState = contextModality;
            if (modalityState == null) {
                CoreProgressManager.$$$reportNull$$$0(50);
            }
            return modalityState;
        }
        ProgressManager progressManager = ProgressManager.getInstanceOrNull();
        ModalityState progressModality = progressManager == null ? null : progressManager.getCurrentProgressModality();
        ModalityState modalityState = progressModality == null ? ModalityState.nonModal() : progressModality;
        if (modalityState == null) {
            CoreProgressManager.$$$reportNull$$$0(51);
        }
        return modalityState;
    }

    private static void setCurrentIndicator(long threadId, ProgressIndicator indicator) {
        if (indicator == null) {
            currentIndicators.remove(threadId);
            threadTopLevelIndicators.remove(threadId);
        } else {
            currentIndicators.put(threadId, indicator);
            threadTopLevelIndicators.putIfAbsent(threadId, indicator);
        }
    }

    private static ProgressIndicator getCurrentIndicator(@NotNull Thread thread2) {
        if (thread2 == null) {
            CoreProgressManager.$$$reportNull$$$0(52);
        }
        return currentIndicators.get(thread2.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <X> X silenceGlobalIndicator(@NotNull Supplier<? extends X> computable) {
        if (computable == null) {
            CoreProgressManager.$$$reportNull$$$0(53);
        }
        long id = Thread.currentThread().getId();
        ProgressIndicator topLevelIndicator = threadTopLevelIndicators.remove(id);
        ProgressIndicator currentIndicator = currentIndicators.remove(id);
        try {
            X x = computable.get();
            return x;
        }
        finally {
            if (currentIndicator != null) {
                currentIndicators.put(id, currentIndicator);
            }
            if (topLevelIndicator != null) {
                threadTopLevelIndicators.put(id, topLevelIndicator);
            }
        }
    }

    @Override
    @Nullable
    public ModalityState getCurrentProgressModality() {
        ProgressIndicator indicator = threadTopLevelIndicators.get(Thread.currentThread().getId());
        return indicator == null ? null : indicator.getModalityState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertUnderProgress(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            CoreProgressManager.$$$reportNull$$$0(54);
        }
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            Set<Thread> threads = threadsUnderIndicator.get(indicator);
            if (threads == null || !threads.contains(Thread.currentThread())) {
                ProgressIndicator current = threadTopLevelIndicators.get(Thread.currentThread().getId());
                LOG.error("Must be executed under progress indicator: " + indicator + " but the process is running under " + current + " indicator instead. Please see e.g. ProgressManager.runProcess()");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/impl/CoreProgressManager";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 38: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 3: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: 
            case 47: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 21: 
            case 26: 
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 24: 
            case 41: 
            case 45: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 27: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentThread";
                break;
            }
            case 44: 
            case 46: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentIndicators";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/impl/CoreProgressManager";
                break;
            }
            case 19: 
            case 22: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcessWithProgressAsynchronously";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentThreadProgressModality";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "runProcess";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "assertNoOtherThreadUnder";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "executeNonCancelableSection";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeInNonCancelableSection";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressSynchronously";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressAsynchronously";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "runAsynchronously";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultAsynchronousProgressIndicator";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "startTask";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "notifyTaskFinished";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "shouldEnterModalityState";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressInCurrentThread";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "finishTask";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "executeProcessUnderProgress";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "runInReadActionWithWriteActionPriority";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "computeUnderProgress";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "registerIndicatorAndRun";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "updateThreadUnderCanceledIndicator";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "indicatorCanceled";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isCanceledThread";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "computePrioritized";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "changePrioritizing";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "suppressAllDeprioritizationsDuringLongTestsExecutionIn";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentIndicator";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "silenceGlobalIndicator";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "assertUnderProgress";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum CheckCanceledBehavior {
        NONE,
        ONLY_HOOKS,
        INDICATOR_PLUS_HOOKS;

    }

    private static class IndicatorDisposable
    implements Disposable {
        @NotNull
        private final ProgressIndicator myIndicator;

        IndicatorDisposable(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                IndicatorDisposable.$$$reportNull$$$0(0);
            }
            this.myIndicator = indicator;
        }

        @Override
        public void dispose() {
            Disposer.dispose((Disposable)((Object)this.myIndicator), false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager$IndicatorDisposable", "<init>"));
        }
    }

    @FunctionalInterface
    static interface CheckCanceledHook {
        public static final CheckCanceledHook[] EMPTY_ARRAY = new CheckCanceledHook[0];

        public boolean runHook(@Nullable ProgressIndicator var1);
    }
}

