/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.FunctionalExpressionStub;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.tree.java.MethodReferenceResolver;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.conflictResolvers.DuplicateConflictResolver;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiMethodReferenceExpressionImpl
extends JavaStubPsiElement<FunctionalExpressionStub<PsiMethodReferenceExpression>>
implements PsiMethodReferenceExpression {
    private static final Logger LOG = Logger.getInstance(PsiMethodReferenceExpressionImpl.class);
    private static final MethodReferenceResolver RESOLVER = new MethodReferenceResolver();

    public PsiMethodReferenceExpressionImpl(@NotNull FunctionalExpressionStub<PsiMethodReferenceExpression> stub) {
        if (stub == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(0);
        }
        super(stub, (IStubElementType)JavaStubElementTypes.METHOD_REF_EXPRESSION);
    }

    public PsiMethodReferenceExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(1);
        }
        super(node);
    }

    @Override
    public PsiTypeElement getQualifierType() {
        PsiElement qualifier = this.getQualifier();
        return qualifier instanceof PsiTypeElement ? (PsiTypeElement)qualifier : null;
    }

    @Override
    @Nullable
    public PsiType getFunctionalInterfaceType() {
        return this.getGroundTargetType(LambdaUtil.getFunctionalInterfaceType(this, true));
    }

    @Override
    public boolean isExact() {
        return this.getPotentiallyApplicableMember() != null;
    }

    @Override
    public boolean isPotentiallyCompatible(@Nullable PsiType functionalInterfaceType) {
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(functionalInterfaceType);
        if (interfaceMethod == null) {
            return false;
        }
        MethodReferenceResolver resolver = new MethodReferenceResolver(){

            @Override
            protected PsiConflictResolver createResolver(@NotNull PsiMethodReferenceExpressionImpl referenceExpression, @NotNull PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult, PsiMethod interfaceMethod, MethodSignature signature) {
                if (referenceExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (qualifierResolveResult == null) {
                    1.$$$reportNull$$$0(1);
                }
                return DuplicateConflictResolver.INSTANCE;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "referenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "qualifierResolveResult";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl$1";
                objectArray[2] = "createResolver";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ResolveResult[] result2 = LambdaUtil.performWithTargetType(this, functionalInterfaceType, () -> resolver.resolve(this, this.getContainingFile(), false));
        PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(this);
        int interfaceArity = interfaceMethod.getParameterList().getParametersCount();
        for (ResolveResult resolveResult : result2) {
            PsiElement element = resolveResult.getElement();
            if (element instanceof PsiMethod) {
                boolean isStatic = ((PsiMethod)element).hasModifierProperty("static");
                int parametersCount = ((PsiMethod)element).getParameterList().getParametersCount();
                if (qualifierResolveResult.isReferenceTypeQualified() && this.getReferenceNameElement() instanceof PsiIdentifier) {
                    int offset;
                    int n = offset = isStatic ? 0 : 1;
                    if (parametersCount == interfaceArity - offset) {
                        return true;
                    }
                    if (!((PsiMethod)element).isVarArgs() || !interfaceMethod.isVarArgs() && interfaceArity < parametersCount + offset - 1) continue;
                    return true;
                }
                if (isStatic) continue;
                if (parametersCount == interfaceArity) {
                    return true;
                }
                if (!((PsiMethod)element).isVarArgs() || !interfaceMethod.isVarArgs() && interfaceArity < parametersCount - 1) continue;
                return true;
            }
            if (!(element instanceof PsiClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public PsiType getGroundTargetType(PsiType functionalInterfaceType) {
        return FunctionalInterfaceParameterizationUtil.getGroundTargetType(functionalInterfaceType);
    }

    @Override
    public PsiMember getPotentiallyApplicableMember() {
        return (PsiMember)CachedValuesManager.getCachedValue(this, () -> CachedValueProvider.Result.create(this.getPotentiallyApplicableMemberInternal(), PsiModificationTracker.MODIFICATION_COUNT, this));
    }

    private PsiMember getPotentiallyApplicableMemberInternal() {
        PsiElement resolve;
        PsiElement element = this.getReferenceNameElement();
        PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(this);
        PsiClass containingClass = qualifierResolveResult.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        PsiElement qualifier = this.getQualifier();
        if (qualifier instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)qualifier).resolve()) instanceof PsiClass && ((PsiClass)resolve).hasTypeParameters()) {
            return null;
        }
        PsiMethod[] methods = null;
        if (element instanceof PsiIdentifier) {
            String identifierName = element.getText();
            methods = containingClass.findMethodsByName(identifierName, true);
            if (methods.length == 0) {
                return null;
            }
            if (methods.length > 1) {
                ArrayList<PsiMethod> result2 = new ArrayList<PsiMethod>();
                for (HierarchicalMethodSignature signature : containingClass.getVisibleSignatures()) {
                    if (!identifierName.equals(signature.getName())) continue;
                    result2.add(signature.getMethod());
                }
                if (result2.isEmpty()) {
                    return null;
                }
                methods = result2.toArray(PsiMethod.EMPTY_ARRAY);
            }
        } else if (this.isConstructor()) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(this.getProject());
            if (factory.isArrayClass(containingClass)) {
                PsiTypeParameter[] typeParameters = containingClass.getTypeParameters();
                if (typeParameters.length != 1) {
                    return null;
                }
                PsiType componentType = qualifierResolveResult.getSubstitutor().substitute(typeParameters[0]);
                LOG.assertTrue(componentType != null, qualifierResolveResult.getSubstitutor());
                return factory.createMethodFromText("public " + componentType.createArrayType().getCanonicalText() + " __array__(int i) {return null;}", this);
            }
            methods = containingClass.getConstructors();
        }
        if (methods != null) {
            PsiMethod psiMethod = null;
            if (methods.length > 0) {
                for (PsiMethod method : methods) {
                    if (!PsiUtil.isAccessible(method, this, null)) continue;
                    if (psiMethod != null) {
                        return null;
                    }
                    psiMethod = method;
                }
                if (psiMethod == null) {
                    return null;
                }
                if (psiMethod.isVarArgs()) {
                    return null;
                }
                if (psiMethod.getTypeParameters().length > 0) {
                    PsiReferenceParameterList parameterList = this.getParameterList();
                    return parameterList != null && parameterList.getTypeParameterElements().length > 0 ? psiMethod : null;
                }
            }
            return psiMethod == null ? containingClass : psiMethod;
        }
        return null;
    }

    @Override
    public PsiExpression getQualifierExpression() {
        PsiElement qualifier = this.getQualifier();
        return qualifier instanceof PsiExpression ? (PsiExpression)qualifier : null;
    }

    @Override
    public PsiType getType() {
        return new PsiMethodReferenceType(this);
    }

    @Override
    public PsiElement getReferenceNameElement() {
        PsiElement element = this.getLastChild();
        return element instanceof PsiIdentifier || PsiUtil.isJavaToken(element, JavaTokenType.NEW_KEYWORD) ? element : null;
    }

    @Override
    public void processVariants(@NotNull PsiScopeProcessor processor) {
        if (processor == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(2);
        }
        FilterScopeProcessor proc = new FilterScopeProcessor((ElementFilter)ElementClassFilter.METHOD, processor);
        PsiScopesUtil.resolveAndWalk(proc, this, null, true);
    }

    @Override
    public void setQualifierExpression(@Nullable PsiExpression newQualifier) throws IncorrectOperationException {
        if (newQualifier == null) {
            LOG.error("Forbidden null qualifier");
            return;
        }
        PsiExpression expression = this.getQualifierExpression();
        if (expression != null) {
            expression.replace(newQualifier);
        } else {
            PsiElement qualifier = this.getQualifier();
            if (qualifier != null) {
                qualifier.replace(newQualifier);
            }
        }
    }

    @Override
    public JavaResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        JavaResolveResult[] javaResolveResultArray = PsiImplUtil.multiResolveImpl(this, incompleteCode, RESOLVER);
        if (javaResolveResultArray == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(3);
        }
        return javaResolveResultArray;
    }

    @Override
    public PsiElement getQualifier() {
        PsiElement element = this.getFirstChild();
        return element instanceof PsiExpression || element instanceof PsiTypeElement ? element : null;
    }

    @Override
    @NotNull
    public TextRange getRangeInElement() {
        PsiElement element = this.getReferenceNameElement();
        if (element != null) {
            int offsetInParent = element.getStartOffsetInParent();
            return new TextRange(offsetInParent, offsetInParent + element.getTextLength());
        }
        Object colons = this.findChildByType(JavaTokenType.DOUBLE_COLON);
        if (colons != null) {
            int offsetInParent = colons.getStartOffsetInParent();
            return new TextRange(offsetInParent, offsetInParent + colons.getTextLength());
        }
        LOG.error(this.getText());
        if (null == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(4);
        }
        return null;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string2 = this.getText();
        if (string2 == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(6);
        }
        if (!(element instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)element;
        PsiElement nameElement = this.getReferenceNameElement();
        if (nameElement instanceof PsiIdentifier ? !nameElement.getText().equals(method.getName()) : PsiUtil.isJavaToken(nameElement, JavaTokenType.NEW_KEYWORD) && !method.isConstructor()) {
            return false;
        }
        return element.getManager().areElementsEquivalent(element, this.resolve());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(7);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitMethodReferenceExpression(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(8);
        }
        CheckUtil.checkWritable(this);
        if (this.isReferenceTo(element) || !this.isPhysical()) {
            return this;
        }
        if (element instanceof PsiMethod) {
            return this.handleElementRename(((PsiMethod)element).getName());
        }
        if (element instanceof PsiClass) {
            return this;
        }
        throw new IncorrectOperationException(element.toString());
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(9);
        }
        if (this.isConstructor()) {
            return this;
        }
        PsiElement oldIdentifier = this.getReferenceNameElement();
        if (oldIdentifier == null) {
            throw new IncorrectOperationException();
        }
        PsiIdentifier identifier = JavaPsiFacade.getElementFactory(this.getProject()).createIdentifier(newElementName);
        oldIdentifier.replace(identifier);
        return this;
    }

    @Override
    public boolean isConstructor() {
        PsiElement element = this.getReferenceNameElement();
        return element instanceof PsiKeyword && "new".equals(element.getText());
    }

    @Override
    public String toString() {
        return "PsiMethodReferenceExpression";
    }

    @Override
    public boolean isAcceptable(PsiType left, PsiMethod method) {
        if (left instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)left).getConjuncts()) {
                if (!this.isAcceptable(conjunct)) continue;
                return true;
            }
            return false;
        }
        PsiExpressionList argsList = PsiTreeUtil.getParentOfType((PsiElement)this, PsiExpressionList.class);
        boolean isExact = this.isExact();
        if (method != null && MethodCandidateInfo.isOverloadCheck(argsList)) {
            if (isExact && !InferenceSession.isPertinentToApplicability(this, method)) {
                return true;
            }
            if (LambdaUtil.isPotentiallyCompatibleWithTypeParameter(this, argsList, method)) {
                return true;
            }
        }
        if (!this.isPotentiallyCompatible(left = this.getGroundTargetType(left))) {
            return false;
        }
        if (MethodCandidateInfo.isOverloadCheck(argsList) && !isExact) {
            return true;
        }
        JavaResolveResult result2 = LambdaUtil.performWithTargetType(this, left, () -> this.advancedResolve(false));
        if (result2 instanceof MethodCandidateInfo && !((MethodCandidateInfo)result2).isApplicable()) {
            return false;
        }
        PsiElement resolve = result2.getElement();
        if (resolve == null) {
            return false;
        }
        return PsiMethodReferenceUtil.isReturnTypeCompatible(this, result2, left);
    }

    @Override
    @Nullable
    public Icon getIcon(int flags) {
        return IconManager.getInstance().getPlatformIcon(PlatformIcons.MethodReference);
    }

    @Override
    public PsiElement bindToElementViaStaticImport(@NotNull PsiClass qualifierClass) throws IncorrectOperationException {
        if (qualifierClass == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(10);
        }
        throw new IncorrectOperationException();
    }

    @Override
    @NotNull
    public PsiElement getElement() {
        PsiMethodReferenceExpressionImpl psiMethodReferenceExpressionImpl = this;
        if (psiMethodReferenceExpressionImpl == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(11);
        }
        return psiMethodReferenceExpressionImpl;
    }

    @Override
    public PsiElement resolve() {
        return this.advancedResolve(false).getElement();
    }

    @Override
    public Object @NotNull [] getVariants() {
        if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(12);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult[] results = this.multiResolve(incompleteCode);
        JavaResolveResult javaResolveResult = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(13);
        }
        return javaResolveResult;
    }

    @Override
    public String getReferenceName() {
        PsiElement element = this.getReferenceNameElement();
        return element != null ? element.getText() : null;
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        return PsiTreeUtil.getChildOfType(this, PsiReferenceParameterList.class);
    }

    @Override
    public PsiType @NotNull [] getTypeParameters() {
        PsiReferenceParameterList parameterList = this.getParameterList();
        PsiType[] psiTypeArray = parameterList != null ? parameterList.getTypeArguments() : PsiType.EMPTY_ARRAY;
        if (psiTypeArray == null) {
            PsiMethodReferenceExpressionImpl.$$$reportNull$$$0(14);
        }
        return psiTypeArray;
    }

    @Override
    public boolean isQualified() {
        return this.getQualifier() != null;
    }

    @Override
    public String getQualifiedName() {
        return this.getCanonicalText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "advancedResolve";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processVariants";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "bindToElementViaStaticImport";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

