/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.EmptyStackException;

public final class LongStack {
    private long[] data;
    private int size;

    public LongStack(int initialCapacity) {
        this.data = new long[initialCapacity];
        this.size = 0;
    }

    public LongStack() {
        this(5);
    }

    public void push(long t2) {
        if (this.size >= this.data.length) {
            this.data = ArrayUtil.realloc(this.data, this.data.length * 3 / 2);
        }
        this.data[this.size++] = t2;
    }

    public long peek() {
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        return this.data[this.size - 1];
    }

    public long pop() {
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        return this.data[--this.size];
    }

    public boolean empty() {
        return this.size == 0;
    }

    public boolean equals(Object o) {
        if (o instanceof LongStack) {
            LongStack otherStack = (LongStack)o;
            if (this.size != otherStack.size) {
                return false;
            }
            for (int i = 0; i < otherStack.size; ++i) {
                if (this.data[i] == otherStack.data[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void clear() {
        this.size = 0;
    }

    public String toString() {
        return Arrays.toString(Arrays.copyOf(this.data, this.size));
    }
}

