/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.containers.FList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.graph.impl.GraphEdge;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;

public final class KShortestPathsFinder<Node> {
    private static final Logger LOG = Logger.getInstance(KShortestPathsFinder.class);
    private final InboundSemiGraph<Node> myGraph;
    private final Node myStart;
    private final Node myFinish;
    private final ProgressIndicator myProgressIndicator;
    private MultiMap<Node, GraphEdge<Node>> myNonTreeEdges;
    private List<Node> mySortedNodes;
    private Map<Node, Node> myNextNodes;
    private Map<Node, HeapNode<Node>> myOutRoots;
    private Map<Node, Heap<Node>> myHeaps;

    public KShortestPathsFinder(@NotNull Graph<Node> graph2, @NotNull Node start, @NotNull Node finish, @NotNull ProgressIndicator progress) {
        if (graph2 == null) {
            KShortestPathsFinder.$$$reportNull$$$0(0);
        }
        if (start == null) {
            KShortestPathsFinder.$$$reportNull$$$0(1);
        }
        if (finish == null) {
            KShortestPathsFinder.$$$reportNull$$$0(2);
        }
        if (progress == null) {
            KShortestPathsFinder.$$$reportNull$$$0(3);
        }
        this((InboundSemiGraph<Node>)graph2, start, finish, progress);
    }

    public KShortestPathsFinder(@NotNull InboundSemiGraph<Node> graph2, @NotNull Node start, @NotNull Node finish, @NotNull ProgressIndicator progress) {
        if (graph2 == null) {
            KShortestPathsFinder.$$$reportNull$$$0(4);
        }
        if (start == null) {
            KShortestPathsFinder.$$$reportNull$$$0(5);
        }
        if (finish == null) {
            KShortestPathsFinder.$$$reportNull$$$0(6);
        }
        if (progress == null) {
            KShortestPathsFinder.$$$reportNull$$$0(7);
        }
        this.myGraph = graph2;
        this.myStart = start;
        this.myFinish = finish;
        this.myProgressIndicator = progress;
    }

    private void computeDistancesToTarget() {
        this.myNonTreeEdges = new MultiMap();
        this.mySortedNodes = new ArrayList<Node>();
        this.myNextNodes = new HashMap<Node, Node>();
        Object2IntOpenHashMap<Node> distances = new Object2IntOpenHashMap<Node>();
        ArrayDeque<Node> nodes = new ArrayDeque<Node>();
        nodes.addLast(this.myFinish);
        distances.put(this.myFinish, 0);
        while (!nodes.isEmpty()) {
            this.myProgressIndicator.checkCanceled();
            Object node = nodes.removeFirst();
            this.mySortedNodes.add(node);
            int d = distances.getInt(node) + 1;
            Iterator<Node> iterator2 = this.myGraph.getIn(node);
            while (iterator2.hasNext()) {
                Node prev = iterator2.next();
                if (distances.containsKey(prev)) {
                    int dPrev = distances.getInt(prev);
                    this.myNonTreeEdges.putValue(prev, new GraphEdge<Node>(prev, node, d - dPrev));
                    continue;
                }
                distances.put(prev, d);
                this.myNextNodes.put(prev, node);
                nodes.addLast(prev);
            }
        }
    }

    private void buildOutHeaps() {
        this.myOutRoots = new HashMap<Node, HeapNode<Node>>();
        for (Node node : this.mySortedNodes) {
            int j;
            this.myProgressIndicator.checkCanceled();
            ArrayList heapNodes = new ArrayList();
            Collection<GraphEdge<Node>> edges = this.myNonTreeEdges.get(node);
            if (edges.isEmpty()) continue;
            HeapNode root = null;
            for (GraphEdge<Node> edge : edges) {
                HeapNode heapNode = new HeapNode(edge);
                heapNodes.add(heapNode);
                if (root != null && root.myEdge.getDelta() <= heapNode.myEdge.getDelta()) continue;
                root = heapNode;
            }
            heapNodes.remove(root);
            this.myOutRoots.put(node, root);
            if (heapNodes.isEmpty()) continue;
            for (j = 1; j < heapNodes.size(); ++j) {
                HeapNode heapNode = (HeapNode)heapNodes.get(j);
                HeapNode parent = (HeapNode)heapNodes.get((j + 1) / 2 - 1);
                parent.myChildren[(j + 1) % 2] = heapNode;
            }
            for (j = heapNodes.size() / 2 - 1; j >= 0; --j) {
                this.heapify((HeapNode)heapNodes.get(j));
            }
            root.myChildren[2] = (HeapNode)heapNodes.get(0);
        }
    }

    private void buildMainHeaps() {
        this.myHeaps = new HashMap<Node, Heap<Node>>();
        for (Node node : this.mySortedNodes) {
            this.myProgressIndicator.checkCanceled();
            HeapNode<Node> outRoot = this.myOutRoots.get(node);
            Node next2 = this.myNextNodes.get(node);
            if (outRoot == null) {
                if (next2 == null) continue;
                this.myHeaps.put(node, this.myHeaps.get(next2));
                continue;
            }
            Heap<Node> nextHeap = this.myHeaps.get(next2);
            if (nextHeap == null) {
                this.myHeaps.put(node, new Heap<Node>(outRoot));
                continue;
            }
            Heap<Node> tHeap = nextHeap.insert(outRoot);
            this.myHeaps.put(node, tHeap);
        }
    }

    private void heapify(HeapNode<Node> node) {
        while (true) {
            HeapNode<Node> min2 = node;
            for (int i = 0; i < 2; ++i) {
                HeapNode child = node.myChildren[i];
                if (child == null || child.myEdge.getDelta() >= min2.myEdge.getDelta()) continue;
                min2 = child;
            }
            if (min2 == node) break;
            GraphEdge t2 = min2.myEdge;
            min2.myEdge = node.myEdge;
            node.myEdge = t2;
            node = min2;
        }
    }

    public List<List<Node>> findShortestPaths(int k) {
        try {
            if (this.myStart.equals(this.myFinish)) {
                return Collections.singletonList(Collections.singletonList(this.myStart));
            }
            this.computeDistancesToTarget();
            if (!this.myNextNodes.containsKey(this.myStart)) {
                return Collections.emptyList();
            }
            this.buildOutHeaps();
            this.buildMainHeaps();
            PriorityQueue queue = new PriorityQueue();
            ArrayList<FList<HeapNode<Node>>> sidetracks = new ArrayList<FList<HeapNode<Node>>>();
            sidetracks.add(FList.emptyList());
            Heap<Node> heap = this.myHeaps.get(this.myStart);
            if (heap != null) {
                queue.add(new Sidetracks(0, FList.singleton(heap.getRoot())));
                for (int i = 2; i <= k && !queue.isEmpty(); ++i) {
                    this.myProgressIndicator.checkCanceled();
                    Sidetracks current = (Sidetracks)queue.remove();
                    sidetracks.add(current.myEdges);
                    HeapNode e = (HeapNode)current.myEdges.getHead();
                    Heap<Node> next2 = this.myHeaps.get(e.myEdge.getFinish());
                    if (next2 != null) {
                        HeapNode<Node> f = next2.getRoot();
                        queue.add(new Sidetracks(current.myLength + f.myEdge.getDelta(), current.myEdges.prepend(f)));
                    }
                    for (HeapNode child : e.myChildren) {
                        if (child == null) continue;
                        queue.add(new Sidetracks(current.myLength - e.myEdge.getDelta() + child.myEdge.getDelta(), current.myEdges.getTail().prepend(child)));
                    }
                }
            }
            return this.computePathsBySidetracks(sidetracks);
        }
        catch (ProcessCanceledException e) {
            return Collections.emptyList();
        }
    }

    private List<List<Node>> computePathsBySidetracks(List<FList<HeapNode<Node>>> sidetracks) {
        ArrayList<List<Node>> result2 = new ArrayList<List<Node>>();
        for (FList<HeapNode<Node>> sidetrack : sidetracks) {
            this.myProgressIndicator.checkCanceled();
            ArrayList edges = new ArrayList();
            while (!sidetrack.isEmpty()) {
                edges.add(sidetrack.getHead().myEdge);
                sidetrack = sidetrack.getTail();
            }
            Node current = this.myStart;
            ArrayList<Node> path = new ArrayList<Node>();
            path.add(current);
            int i = edges.size() - 1;
            while (!current.equals(this.myFinish) || i >= 0) {
                if (i >= 0 && ((GraphEdge)edges.get(i)).getStart().equals(current)) {
                    current = ((GraphEdge)edges.get(i)).getFinish();
                    --i;
                } else {
                    LOG.assertTrue((current = this.myNextNodes.get(current)) != null);
                }
                path.add(current);
            }
            result2.add(path);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "graph";
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "start";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[0] = "finish";
                break;
            }
            case 3: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[0] = "progress";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/graph/impl/KShortestPathsFinder";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class HeapNode<Node> {
        public HeapNode<Node>[] myChildren;
        public GraphEdge<Node> myEdge;

        private HeapNode(GraphEdge<Node> edge) {
            this.myEdge = edge;
            this.myChildren = new HeapNode[3];
        }

        HeapNode(HeapNode<Node> node) {
            this.myEdge = node.myEdge;
            this.myChildren = (HeapNode[])node.myChildren.clone();
        }

        public HeapNode<Node> copy() {
            return new HeapNode<Node>(this);
        }
    }

    private static class Heap<Node> {
        private final int mySize;
        private final HeapNode<Node> myRoot;

        Heap(HeapNode<Node> root) {
            this.myRoot = root;
            this.mySize = 1;
        }

        private Heap(int size, HeapNode<Node> root) {
            this.mySize = size;
            this.myRoot = root;
        }

        public HeapNode<Node> getRoot() {
            return this.myRoot;
        }

        public Heap<Node> insert(HeapNode<Node> node) {
            HeapNode<Node> newRoot;
            int pos = this.mySize + 1;
            int pow = 1;
            while (pos >= pow << 2) {
                pow <<= 1;
            }
            HeapNode<Node> place = newRoot = this.myRoot.copy();
            ArrayList<HeapNode<Node>> parents2 = new ArrayList<HeapNode<Node>>();
            while (true) {
                int ind;
                parents2.add(place);
                int n = ind = (pos & pow) != 0 ? 1 : 0;
                if (pow == 1) break;
                HeapNode copy = place.myChildren[ind].copy();
                place.myChildren[ind] = copy;
                place = copy;
                pow >>= 1;
            }
            place.myChildren[ind] = node;
            for (int i = parents2.size() - 1; i >= 0; --i) {
                HeapNode parent = (HeapNode)parents2.get(i);
                if (parent.myEdge.getDelta() < node.myEdge.getDelta()) break;
                GraphEdge t2 = parent.myEdge;
                parent.myEdge = node.myEdge;
                node.myEdge = t2;
                HeapNode t22 = parent.myChildren[2];
                parent.myChildren[2] = node.myChildren[2];
                node.myChildren[2] = t22;
                node = parent;
            }
            return new Heap<Node>(this.mySize + 1, newRoot);
        }
    }

    private static final class Sidetracks<Node>
    implements Comparable<Sidetracks> {
        private final int myLength;
        private final FList<HeapNode<Node>> myEdges;

        private Sidetracks(int length, FList<HeapNode<Node>> edges) {
            this.myLength = length;
            this.myEdges = edges;
        }

        @Override
        public int compareTo(Sidetracks o) {
            return this.myLength - o.myLength;
        }
    }
}

