/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.dev.intmultimaps;

import java.util.Arrays;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class Int2IntMultimap {
    public static final int NO_VALUE = 0;
    private final float loadFactor;
    private int @NotNull [] table;
    private int aliveValues = 0;
    private int filledSlots = 0;

    public Int2IntMultimap() {
        this(16, 0.4f);
    }

    public Int2IntMultimap(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.table = new int[capacity * 2];
        Arrays.fill(this.table, 0);
    }

    public boolean lookup(int key, IntPredicate valuesProcessor) {
        Int2IntMultimap.checkNotNoValue("key", key);
        int capacity = this.capacity();
        int startIndex = Math.abs(key % capacity);
        for (int probe = 0; probe < capacity; ++probe) {
            int slotIndex = (startIndex + probe) % capacity;
            int slotKey = this.table[slotIndex * 2];
            int slotValue = this.table[slotIndex * 2 + 1];
            if (slotKey == key) {
                assert (slotValue != 0) : "value(table[" + (slotIndex * 2 + 1) + "]) = " + 0 + " (NO_VALUE), while key(table[" + slotIndex * 2 + "]) = " + key;
                if (valuesProcessor.test(slotValue)) continue;
                return false;
            }
            if (slotKey == 0 && slotValue == 0) break;
        }
        return true;
    }

    public boolean has(int key, int value) {
        Int2IntMultimap.checkNotNoValue("key", key);
        Int2IntMultimap.checkNotNoValue("value", value);
        int capacity = this.capacity();
        int startIndex = Math.abs(key % capacity);
        for (int probe = 0; probe < capacity; ++probe) {
            int slotIndex = (startIndex + probe) % capacity;
            int slotKey = this.table[slotIndex * 2];
            int slotValue = this.table[slotIndex * 2 + 1];
            if (slotKey == key && slotValue == value) {
                return true;
            }
            if (slotKey == 0 && slotValue == 0) break;
        }
        return false;
    }

    public boolean put(int key, int value) {
        Int2IntMultimap.checkNotNoValue("key", key);
        Int2IntMultimap.checkNotNoValue("value", value);
        int capacity = this.capacity();
        int startIndex = Math.abs(key % capacity);
        int firstTombstoneIndex = -1;
        for (int probe = 0; probe < capacity; ++probe) {
            int slotIndex = (startIndex + probe) % capacity;
            int slotKey = this.table[slotIndex * 2];
            int slotValue = this.table[slotIndex * 2 + 1];
            if (slotKey == key && slotValue == value) {
                return false;
            }
            if (slotKey != 0) continue;
            if (slotValue != 0) {
                if (firstTombstoneIndex != -1) continue;
                firstTombstoneIndex = slotIndex;
                continue;
            }
            int insertionIndex = firstTombstoneIndex >= 0 ? firstTombstoneIndex : slotIndex;
            this.table[insertionIndex * 2] = key;
            this.table[insertionIndex * 2 + 1] = value;
            ++this.aliveValues;
            break;
        }
        if ((float)this.aliveValues > (float)capacity * this.loadFactor) {
            Int2IntMultimap newMMap = new Int2IntMultimap(capacity * 2, this.loadFactor);
            this.forEach((_key, _value) -> {
                newMMap.put(_key, _value);
                return true;
            });
            this.table = newMMap.table;
            this.aliveValues = newMMap.aliveValues;
            this.filledSlots = newMMap.aliveValues;
        }
        return true;
    }

    public void remove(int key, int value) {
        Int2IntMultimap.checkNotNoValue("key", key);
        Int2IntMultimap.checkNotNoValue("value", value);
        int capacity = this.capacity();
        int startIndex = Math.abs(key % capacity);
        for (int probe = 0; probe < capacity; ++probe) {
            int slotIndex = (startIndex + probe) % capacity;
            int slotKey = this.table[slotIndex * 2];
            int slotValue = this.table[slotIndex * 2 + 1];
            if (slotKey == key && slotValue == value) {
                this.table[slotIndex * 2] = 0;
                --this.aliveValues;
                return;
            }
            if (slotKey != 0 || slotValue != 0) continue;
            return;
        }
    }

    public void forEach(KeyValueProcessor processor) {
        for (int i = 0; i < this.table.length; i += 2) {
            int key = this.table[i];
            int value = this.table[i + 1];
            if (key == 0) continue;
            assert (value != 0) : "value(table[" + (i + 1) + "]) = " + 0 + ", while key(table[" + i + "]) = " + key;
            if (processor.process(key, value)) continue;
            return;
        }
    }

    public int sizeInBytes() {
        return this.table.length * 4;
    }

    public int capacity() {
        return this.table.length / 2;
    }

    public int size() {
        return this.aliveValues;
    }

    private static void checkNotNoValue(String paramName, int value) {
        if (value == 0) {
            throw new IllegalArgumentException(paramName + " can't be = " + 0 + " -- it is special value used as NO_VALUE");
        }
    }

    @FunctionalInterface
    public static interface KeyValueProcessor {
        public boolean process(int var1, int var2);
    }
}

