/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.AutomatonMatcher;
import dk.brics.automaton.SpecialOperations;
import dk.brics.automaton.State;
import dk.brics.automaton.Transition;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Set;

public class RunAutomaton
implements Serializable {
    static final long serialVersionUID = 20001L;
    int size;
    boolean[] accept;
    int initial;
    int[] transitions;
    char[] points;
    int[] classmap;

    void setAlphabet() {
        this.classmap = new int[65536];
        int i = 0;
        for (char j = '\u0000'; j <= '\uffff'; ++j) {
            if (i + 1 >= this.points.length || j == this.points[i + 1]) {
                // empty if block
            }
            this.classmap[j] = ++i;
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("initial state: ").append(this.initial).append("\n");
        for (int i = 0; i < this.size; ++i) {
            b.append("state ").append(i);
            if (this.accept[i]) {
                b.append(" [accept]:\n");
            } else {
                b.append(" [reject]:\n");
            }
            for (int j = 0; j < this.points.length; ++j) {
                int k = this.transitions[i * this.points.length + j];
                if (k == -1) continue;
                char min2 = this.points[j];
                char max = j + 1 < this.points.length ? (char)((char)(this.points[j + 1] - '\u0001')) : (char)'\uffff';
                b.append(" ");
                Transition.appendCharString(min2, b);
                if (min2 != max) {
                    b.append("-");
                    Transition.appendCharString(max, b);
                }
                b.append(" -> ").append(k).append("\n");
            }
        }
        return b.toString();
    }

    public int getSize() {
        return this.size;
    }

    public boolean isAccept(int state) {
        return this.accept[state];
    }

    public int getInitialState() {
        return this.initial;
    }

    public char[] getCharIntervals() {
        return (char[])this.points.clone();
    }

    int getCharClass(char c) {
        return SpecialOperations.findIndex(c, this.points);
    }

    private RunAutomaton() {
    }

    public RunAutomaton(Automaton a) {
        this(a, true);
    }

    public static RunAutomaton load(URL url) throws IOException, ClassCastException, ClassNotFoundException {
        return RunAutomaton.load(url.openStream());
    }

    public static RunAutomaton load(InputStream stream) throws IOException, ClassCastException, ClassNotFoundException {
        ObjectInputStream s2 = new ObjectInputStream(stream);
        return (RunAutomaton)s2.readObject();
    }

    public void store(OutputStream stream) throws IOException {
        ObjectOutputStream s2 = new ObjectOutputStream(stream);
        s2.writeObject(this);
        s2.flush();
    }

    public RunAutomaton(Automaton a, boolean tableize) {
        a.determinize();
        this.points = a.getStartPoints();
        Set<State> states = a.getStates();
        Automaton.setStateNumbers(states);
        this.initial = a.initial.number;
        this.size = states.size();
        this.accept = new boolean[this.size];
        this.transitions = new int[this.size * this.points.length];
        for (int n = 0; n < this.size * this.points.length; ++n) {
            this.transitions[n] = -1;
        }
        for (State s2 : states) {
            int n = s2.number;
            this.accept[n] = s2.accept;
            for (int c = 0; c < this.points.length; ++c) {
                State q = s2.step(this.points[c]);
                if (q == null) continue;
                this.transitions[n * this.points.length + c] = q.number;
            }
        }
        if (tableize) {
            this.setAlphabet();
        }
    }

    public int step(int state, char c) {
        if (this.classmap == null) {
            return this.transitions[state * this.points.length + this.getCharClass(c)];
        }
        return this.transitions[state * this.points.length + this.classmap[c - '\u0000']];
    }

    public boolean run(String s2) {
        int p = this.initial;
        int l = s2.length();
        for (int i = 0; i < l; ++i) {
            if ((p = this.step(p, s2.charAt(i))) != -1) continue;
            return false;
        }
        return this.accept[p];
    }

    public int run(String s2, int offset) {
        int p = this.initial;
        int l = s2.length();
        int max = -1;
        int r = 0;
        while (offset <= l) {
            if (this.accept[p]) {
                max = r;
            }
            if (offset == l || (p = this.step(p, s2.charAt(offset))) == -1) break;
            ++offset;
            ++r;
        }
        return max;
    }

    public AutomatonMatcher newMatcher(CharSequence s2) {
        return new AutomatonMatcher(s2, this);
    }

    public AutomatonMatcher newMatcher(CharSequence s2, int startOffset, int endOffset) {
        return new AutomatonMatcher(s2.subSequence(startOffset, endOffset), this);
    }
}

