/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.BasicAutomata;
import dk.brics.automaton.Datatypes;
import dk.brics.automaton.State;
import dk.brics.automaton.StatePair;
import dk.brics.automaton.Transition;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class SpecialOperations {
    private SpecialOperations() {
    }

    public static Set<State> reverse(Automaton a) {
        HashMap m4 = new HashMap();
        Set<State> states = a.getStates();
        Set<State> accept2 = a.getAcceptStates();
        for (State r : states) {
            m4.put(r, new HashSet());
            r.accept = false;
        }
        for (State r : states) {
            for (Transition t2 : r.getTransitions()) {
                ((HashSet)m4.get(t2.to)).add(new Transition(t2.min, t2.max, r));
            }
        }
        for (State r : states) {
            r.transitions = (Set)m4.get(r);
        }
        a.initial.accept = true;
        a.initial = new State();
        for (State r : accept2) {
            a.initial.addEpsilon(r);
        }
        a.deterministic = false;
        return accept2;
    }

    public static Automaton overlap(Automaton a1, Automaton a2) {
        Automaton b1 = a1.cloneExpanded();
        b1.determinize();
        SpecialOperations.acceptToAccept(b1);
        Automaton b2 = a2.cloneExpanded();
        SpecialOperations.reverse(b2);
        b2.determinize();
        SpecialOperations.acceptToAccept(b2);
        SpecialOperations.reverse(b2);
        b2.determinize();
        return b1.intersection(b2).minus(BasicAutomata.makeEmptyString());
    }

    private static void acceptToAccept(Automaton a) {
        State s2 = new State();
        for (State r : a.getAcceptStates()) {
            s2.addEpsilon(r);
        }
        a.initial = s2;
        a.deterministic = false;
    }

    public static Automaton singleChars(Automaton a) {
        State s2;
        Automaton b = new Automaton();
        b.initial = s2 = new State();
        State q = new State();
        q.accept = true;
        if (a.isSingleton()) {
            for (int i = 0; i < a.singleton.length(); ++i) {
                s2.transitions.add(new Transition(a.singleton.charAt(i), q));
            }
        } else {
            for (State p : a.getStates()) {
                for (Transition t2 : p.transitions) {
                    s2.transitions.add(new Transition(t2.min, t2.max, q));
                }
            }
        }
        b.deterministic = true;
        b.removeDeadTransitions();
        return b;
    }

    public static Automaton trim(Automaton a, String set, char c) {
        a = a.cloneExpandedIfRequired();
        State f = new State();
        SpecialOperations.addSetTransitions(f, set, f);
        f.accept = true;
        for (State s2 : a.getStates()) {
            State r = s2.step(c);
            if (r != null) {
                State q = new State();
                SpecialOperations.addSetTransitions(q, set, q);
                SpecialOperations.addSetTransitions(s2, set, q);
                q.addEpsilon(r);
            }
            if (!s2.accept) continue;
            s2.addEpsilon(f);
        }
        State p = new State();
        SpecialOperations.addSetTransitions(p, set, p);
        p.addEpsilon(a.initial);
        a.initial = p;
        a.deterministic = false;
        a.removeDeadTransitions();
        a.checkMinimizeAlways();
        return a;
    }

    private static void addSetTransitions(State s2, String set, State p) {
        for (int n = 0; n < set.length(); ++n) {
            s2.transitions.add(new Transition(set.charAt(n), p));
        }
    }

    public static Automaton compress(Automaton a, String set, char c) {
        a = a.cloneExpandedIfRequired();
        for (State s2 : a.getStates()) {
            State r = s2.step(c);
            if (r == null) continue;
            State q = new State();
            SpecialOperations.addSetTransitions(q, set, q);
            SpecialOperations.addSetTransitions(s2, set, q);
            q.addEpsilon(r);
        }
        a.deterministic = false;
        a.removeDeadTransitions();
        a.checkMinimizeAlways();
        return a;
    }

    public static Automaton subst(Automaton a, Map<Character, Set<Character>> map2) {
        if (map2.isEmpty()) {
            return a.cloneIfRequired();
        }
        TreeSet<Character> ckeys = new TreeSet<Character>(map2.keySet());
        char[] keys2 = new char[ckeys.size()];
        int j = 0;
        for (Character c : ckeys) {
            keys2[j++] = c.charValue();
        }
        a = a.cloneExpandedIfRequired();
        for (State s2 : a.getStates()) {
            Set<Transition> st = s2.transitions;
            s2.resetTransitions();
            block2: for (Transition t2 : st) {
                int index = SpecialOperations.findIndex(t2.min, keys2);
                while (t2.min <= t2.max) {
                    if (keys2[index] > t2.min) {
                        char m4 = (char)(keys2[index] - '\u0001');
                        if (t2.max < m4) {
                            m4 = t2.max;
                        }
                        s2.transitions.add(new Transition(t2.min, m4, t2.to));
                        if (m4 + '\u0001' > 65535) continue block2;
                        t2.min = (char)(m4 + '\u0001');
                        continue;
                    }
                    if (keys2[index] < t2.min) {
                        char m5 = index + 1 < keys2.length ? (char)(keys2[++index] - '\u0001') : (char)'\uffff';
                        if (t2.max < m5) {
                            m5 = t2.max;
                        }
                        s2.transitions.add(new Transition(t2.min, m5, t2.to));
                        if (m5 + '\u0001' > 65535) continue block2;
                        t2.min = (char)(m5 + '\u0001');
                        continue;
                    }
                    for (Character c : map2.get(Character.valueOf(t2.min))) {
                        s2.transitions.add(new Transition(c.charValue(), t2.to));
                    }
                    if (t2.min + '\u0001' > 65535) continue block2;
                    t2.min = (char)(t2.min + '\u0001');
                    if (index + 1 >= keys2.length || keys2[index + 1] != t2.min) continue;
                    ++index;
                }
            }
        }
        a.deterministic = false;
        a.removeDeadTransitions();
        a.checkMinimizeAlways();
        return a;
    }

    static int findIndex(char c, char[] points) {
        int a = 0;
        int b = points.length;
        while (b - a > 1) {
            int d = a + b >>> 1;
            if (points[d] > c) {
                b = d;
                continue;
            }
            if (points[d] < c) {
                a = d;
                continue;
            }
            return d;
        }
        return a;
    }

    public static Automaton subst(Automaton a, char c, String s2) {
        a = a.cloneExpandedIfRequired();
        HashSet<StatePair> epsilons = new HashSet<StatePair>();
        for (State p : a.getStates()) {
            Set<Transition> st = p.transitions;
            p.resetTransitions();
            for (Transition t2 : st) {
                if (t2.max < c || t2.min > c) {
                    p.transitions.add(t2);
                    continue;
                }
                if (t2.min < c) {
                    p.transitions.add(new Transition(t2.min, (char)(c - '\u0001'), t2.to));
                }
                if (t2.max > c) {
                    p.transitions.add(new Transition((char)(c + '\u0001'), t2.max, t2.to));
                }
                if (s2.length() == 0) {
                    epsilons.add(new StatePair(p, t2.to));
                    continue;
                }
                State q = p;
                for (int i = 0; i < s2.length(); ++i) {
                    State r = i + 1 == s2.length() ? t2.to : new State();
                    q.transitions.add(new Transition(s2.charAt(i), r));
                    q = r;
                }
            }
        }
        a.addEpsilons(epsilons);
        a.deterministic = false;
        a.removeDeadTransitions();
        a.checkMinimizeAlways();
        return a;
    }

    public static Automaton homomorph(Automaton a, char[] source, char[] dest) {
        a = a.cloneExpandedIfRequired();
        for (State s2 : a.getStates()) {
            Set<Transition> st = s2.transitions;
            s2.resetTransitions();
            for (Transition t2 : st) {
                int length;
                for (int min2 = t2.min; min2 <= t2.max; min2 += length) {
                    int n = SpecialOperations.findIndex((char)min2, source);
                    char nmin = (char)(dest[n] + min2 - source[n]);
                    int end = n + 1 == source.length ? 65535 : source[n + 1] - '\u0001';
                    length = end < t2.max ? end + 1 - min2 : t2.max + '\u0001' - min2;
                    s2.transitions.add(new Transition(nmin, (char)(nmin + length - 1), t2.to));
                }
            }
        }
        a.deterministic = false;
        a.removeDeadTransitions();
        a.checkMinimizeAlways();
        return a;
    }

    public static Automaton projectChars(Automaton a, Set<Character> chars) {
        int i;
        Character[] c = chars.toArray(new Character[chars.size()]);
        char[] cc = new char[c.length];
        boolean normalchars = false;
        for (i = 0; i < c.length; ++i) {
            if (c[i] == null) {
                normalchars = true;
                continue;
            }
            cc[i] = c[i].charValue();
        }
        Arrays.sort(cc);
        if (a.isSingleton()) {
            for (i = 0; i < a.singleton.length(); ++i) {
                char sc = a.singleton.charAt(i);
                if (normalchars && (sc <= '\udfff' || sc >= '\uf900') || Arrays.binarySearch(cc, sc) >= 0) continue;
                return BasicAutomata.makeEmpty();
            }
            return a.cloneIfRequired();
        }
        HashSet<StatePair> epsilons = new HashSet<StatePair>();
        a = a.cloneExpandedIfRequired();
        for (State s2 : a.getStates()) {
            HashSet<Transition> new_transitions = new HashSet<Transition>();
            for (Transition t2 : s2.transitions) {
                boolean addepsilon = false;
                if (t2.min < '\uf900' && t2.max > '\udfff') {
                    int w2;
                    int w1 = Arrays.binarySearch(cc, t2.min > '\ue000' ? (char)t2.min : (char)'\ue000');
                    if (w1 < 0) {
                        w1 = -w1 - 1;
                        addepsilon = true;
                    }
                    if ((w2 = Arrays.binarySearch(cc, t2.max < '\uf8ff' ? (char)t2.max : (char)'\uf8ff')) < 0) {
                        w2 = -w2 - 2;
                        addepsilon = true;
                    }
                    for (int w = w1; w <= w2; ++w) {
                        new_transitions.add(new Transition(cc[w], t2.to));
                        if (w <= w1 || cc[w - 1] + '\u0001' == cc[w]) continue;
                        addepsilon = true;
                    }
                }
                if (normalchars) {
                    if (t2.min <= '\udfff') {
                        new_transitions.add(new Transition(t2.min, t2.max < '\udfff' ? (char)t2.max : (char)'\udfff', t2.to));
                    }
                    if (t2.max >= '\uf900') {
                        new_transitions.add(new Transition(t2.min > '\uf900' ? (char)t2.min : (char)'\uf900', t2.max, t2.to));
                    }
                } else if (t2.min <= '\udfff' || t2.max >= '\uf900') {
                    addepsilon = true;
                }
                if (!addepsilon) continue;
                epsilons.add(new StatePair(s2, t2.to));
            }
            s2.transitions = new_transitions;
        }
        a.reduce();
        a.addEpsilons(epsilons);
        a.removeDeadTransitions();
        a.checkMinimizeAlways();
        return a;
    }

    public static boolean isFinite(Automaton a) {
        if (a.isSingleton()) {
            return true;
        }
        return SpecialOperations.isFinite(a.initial, new HashSet<State>(), new HashSet<State>());
    }

    private static boolean isFinite(State s2, HashSet<State> path, HashSet<State> visited) {
        path.add(s2);
        for (Transition t2 : s2.transitions) {
            if (!path.contains(t2.to) && (visited.contains(t2.to) || SpecialOperations.isFinite(t2.to, path, visited))) continue;
            return false;
        }
        path.remove(s2);
        visited.add(s2);
        return true;
    }

    public static Set<String> getStrings(Automaton a, int length) {
        HashSet<String> strings2 = new HashSet<String>();
        if (a.isSingleton() && a.singleton.length() == length) {
            strings2.add(a.singleton);
        } else if (length >= 0) {
            SpecialOperations.getStrings(a.initial, strings2, new StringBuilder(), length);
        }
        return strings2;
    }

    private static void getStrings(State s2, Set<String> strings2, StringBuilder path, int length) {
        if (length == 0) {
            if (s2.accept) {
                strings2.add(path.toString());
            }
        } else {
            for (Transition t2 : s2.transitions) {
                for (int n = t2.min; n <= t2.max; ++n) {
                    path.append((char)n);
                    SpecialOperations.getStrings(t2.to, strings2, path, length - 1);
                    path.deleteCharAt(path.length() - 1);
                }
            }
        }
    }

    public static Set<String> getFiniteStrings(Automaton a) {
        HashSet<String> strings2 = new HashSet<String>();
        if (a.isSingleton()) {
            strings2.add(a.singleton);
        } else if (!SpecialOperations.getFiniteStrings(a.initial, new HashSet<State>(), strings2, new StringBuilder(), -1)) {
            return null;
        }
        return strings2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Set<String> getFiniteStrings(Automaton a, int limit2) {
        HashSet<String> strings2 = new HashSet<String>();
        if (a.isSingleton()) {
            if (limit2 <= 0) return null;
            strings2.add(a.singleton);
            return strings2;
        } else {
            if (SpecialOperations.getFiniteStrings(a.initial, new HashSet<State>(), strings2, new StringBuilder(), limit2)) return strings2;
            return null;
        }
    }

    private static boolean getFiniteStrings(State s2, HashSet<State> pathstates, HashSet<String> strings2, StringBuilder path, int limit2) {
        pathstates.add(s2);
        for (Transition t2 : s2.transitions) {
            if (pathstates.contains(t2.to)) {
                return false;
            }
            for (int n = t2.min; n <= t2.max; ++n) {
                path.append((char)n);
                if (t2.to.accept) {
                    strings2.add(path.toString());
                    if (limit2 >= 0 && strings2.size() > limit2) {
                        return false;
                    }
                }
                if (!SpecialOperations.getFiniteStrings(t2.to, pathstates, strings2, path, limit2)) {
                    return false;
                }
                path.deleteCharAt(path.length() - 1);
            }
        }
        pathstates.remove(s2);
        return true;
    }

    public static String getCommonPrefix(Automaton a) {
        boolean done;
        if (a.isSingleton()) {
            return a.singleton;
        }
        StringBuilder b = new StringBuilder();
        HashSet<State> visited = new HashSet<State>();
        State s2 = a.initial;
        do {
            done = true;
            visited.add(s2);
            if (s2.accept || s2.transitions.size() != 1) continue;
            Transition t2 = s2.transitions.iterator().next();
            if (t2.min != t2.max || visited.contains(t2.to)) continue;
            b.append(t2.min);
            s2 = t2.to;
            done = false;
        } while (!done);
        return b.toString();
    }

    public static void prefixClose(Automaton a) {
        for (State s2 : a.getStates()) {
            s2.setAccept(true);
        }
        a.clearHashCode();
        a.checkMinimizeAlways();
    }

    public static Automaton hexCases(Automaton a) {
        HashMap<Character, Set<Character>> map2 = new HashMap<Character, Set<Character>>();
        char c1 = 'a';
        char c2 = 'A';
        while (c1 <= 'f') {
            HashSet<Character> ws = new HashSet<Character>();
            ws.add(Character.valueOf(c1));
            ws.add(Character.valueOf(c2));
            map2.put(Character.valueOf(c1), ws);
            map2.put(Character.valueOf(c2), ws);
            c1 = (char)(c1 + '\u0001');
            c2 = (char)(c2 + '\u0001');
        }
        Automaton ws = Datatypes.getWhitespaceAutomaton();
        return ws.concatenate(a.subst(map2)).concatenate(ws);
    }

    public static Automaton replaceWhitespace(Automaton a) {
        HashMap<Character, Set<Character>> map2 = new HashMap<Character, Set<Character>>();
        HashSet<Character> ws = new HashSet<Character>();
        ws.add(Character.valueOf(' '));
        ws.add(Character.valueOf('\t'));
        ws.add(Character.valueOf('\n'));
        ws.add(Character.valueOf('\r'));
        map2.put(Character.valueOf(' '), ws);
        return a.subst(map2);
    }
}

