/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.accesstransformer.parser;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Target {
    public String className();

    public record WildcardFieldTarget(String className) implements Target
    {
        @Override
        public String toString() {
            return this.className() + " FIELDWILDCARD";
        }
    }

    public record WildcardMethodTarget(String className) implements Target
    {
        @Override
        public String toString() {
            return this.className() + " METHODWILDCARD";
        }
    }

    public record MethodTarget(String className, String methodName, String methodDescriptor) implements Target
    {
        @Override
        public String toString() {
            return this.className() + " METHOD " + this.methodName() + this.methodDescriptor();
        }
    }

    public record FieldTarget(String className, String fieldName) implements Target
    {
        @Override
        public String toString() {
            return this.className() + " FIELD " + this.fieldName();
        }
    }

    public record InnerClassTarget(String className, String innerName) implements Target
    {
        @Override
        public String toString() {
            int idx = this.innerName().lastIndexOf(36);
            return this.className() + " INNERCLASS " + this.innerName().substring(idx + 1);
        }
    }

    public record ClassTarget(String className) implements Target
    {
        @Override
        public String toString() {
            return this.className() + " CLASS";
        }
    }
}

