/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.accesstransformer.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class Transformation {
    private final FinalState finalState;
    private final Modifier modifier;
    private final List<String> origins = new ArrayList<String>();

    private Transformation(Modifier modifier, FinalState finalState) {
        this.finalState = finalState;
        this.modifier = modifier;
    }

    public Transformation(Modifier modifier, FinalState finalState, String origin, int lineNumber) {
        this(modifier, finalState);
        this.origins.add(origin + ":" + lineNumber);
    }

    public FinalState finalState() {
        return this.finalState;
    }

    public Modifier modifier() {
        return this.modifier;
    }

    public List<String> origins() {
        return Collections.unmodifiableList(this.origins);
    }

    public Transformation mergeStates(Transformation other) {
        Modifier newModifier = Modifier.values()[Math.min(this.modifier.ordinal(), other.modifier.ordinal())];
        FinalState newFinalState = FinalState.values()[this.finalState.ordinal() | other.finalState.ordinal()];
        Transformation transformation = new Transformation(newModifier, newFinalState);
        transformation.origins.addAll(this.origins);
        transformation.origins.addAll(other.origins);
        return transformation;
    }

    public boolean isValid() {
        return this.finalState != FinalState.CONFLICT;
    }

    public String toString() {
        return this.modifier + " " + this.finalState + " " + String.join((CharSequence)", ", this.origins);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Transformation)) {
            return false;
        }
        Transformation transformation = (Transformation)object;
        return this.finalState == transformation.finalState && this.modifier == transformation.modifier;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.finalState, this.modifier});
    }

    public static enum FinalState {
        LEAVE,
        MAKEFINAL,
        REMOVEFINAL,
        CONFLICT;

    }

    public static enum Modifier {
        PUBLIC,
        PROTECTED,
        DEFAULT,
        PRIVATE;

    }
}

