/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.accesstransformers;

import com.intellij.psi.PsiFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.neoforged.accesstransformer.parser.AccessTransformerFiles;
import net.neoforged.accesstransformer.parser.Target;
import net.neoforged.accesstransformer.parser.Transformation;
import net.neoforged.jst.accesstransformers.ApplyATsVisitor;
import net.neoforged.jst.api.Logger;
import net.neoforged.jst.api.Replacements;
import net.neoforged.jst.api.SourceTransformer;
import net.neoforged.jst.api.TransformContext;
import net.neoforged.problems.Problem;
import net.neoforged.problems.ProblemGroup;
import net.neoforged.problems.ProblemId;
import net.neoforged.problems.ProblemLocation;
import net.neoforged.problems.ProblemReporter;
import net.neoforged.problems.ProblemSeverity;
import picocli.CommandLine;

public class AccessTransformersTransformer
implements SourceTransformer {
    private static final ProblemGroup PROBLEM_GROUP = ProblemGroup.create("access-transformer", "Access Transformers");
    static final ProblemId INVALID_AT = ProblemId.create("invalid-at", "Invalid", PROBLEM_GROUP);
    private static final ProblemId MISSING_TARGET = ProblemId.create("missing-target", "Missing Target", PROBLEM_GROUP);
    private static final Pattern LINE_PATTERN = Pattern.compile("\\bline\\s+(\\d+)");
    private static final Pattern ORIGIN_PATTERN = Pattern.compile("(.*):(\\d+)$");
    @CommandLine.Option(names={"--access-transformer"}, required=true)
    public List<Path> atFiles;
    @CommandLine.Option(names={"--access-transformer-validation"}, description={"The level of validation to use for ats"})
    public AccessTransformerValidation validation = AccessTransformerValidation.LOG;
    private AccessTransformerFiles ats;
    private Map<Target, Transformation> pendingATs;
    private Logger logger;
    private ProblemReporter problemReporter;
    private volatile boolean errored;

    @Override
    public void beforeRun(TransformContext context2) {
        this.ats = new AccessTransformerFiles();
        this.logger = context2.logger();
        this.problemReporter = context2.problemReporter();
        for (Path path : this.atFiles) {
            try {
                this.ats.loadFromPath(path);
            }
            catch (Exception e) {
                this.logger.error("Failed to parse access transformer file %s: %s", path, e.getMessage());
                if (e.getMessage() != null) {
                    Matcher m4 = LINE_PATTERN.matcher(e.getMessage());
                    if (m4.matches()) {
                        int line = 1 + Integer.parseUnsignedInt(m4.group(1));
                        this.problemReporter.report(INVALID_AT, ProblemSeverity.ERROR, ProblemLocation.ofLocationInFile(path, line), e.getMessage());
                    } else {
                        this.problemReporter.report(INVALID_AT, ProblemSeverity.ERROR, ProblemLocation.ofFile(path), e.getMessage());
                    }
                }
                if (e instanceof RuntimeException) {
                    RuntimeException re = (RuntimeException)e;
                    throw re;
                }
                throw new RuntimeException(e);
            }
        }
        this.pendingATs = new ConcurrentHashMap<Target, Transformation>(this.ats.getAccessTransformers());
    }

    @Override
    public boolean afterRun(TransformContext context2) {
        if (!this.pendingATs.isEmpty()) {
            this.pendingATs.forEach((target, transformation) -> {
                if (target instanceof Target.ClassTarget && target.className().contains("$")) {
                    return;
                }
                this.logger.error("Access transformer %s, targeting %s did not apply as its target doesn't exist", transformation, target);
                Problem problem = Problem.builder(MISSING_TARGET).severity(ProblemSeverity.ERROR).contextualLabel("The target " + String.valueOf(target) + " does not exist.").build();
                AccessTransformersTransformer.reportProblem(this.problemReporter, transformation, problem);
            });
            this.errored = true;
        }
        return !this.errored || this.validation != AccessTransformerValidation.ERROR;
    }

    static void reportProblem(ProblemReporter problemReporter, Transformation transformation, Problem problem) {
        for (String origin : transformation.origins()) {
            ProblemLocation problemLocation;
            Matcher m4 = ORIGIN_PATTERN.matcher(origin);
            if (!m4.matches()) {
                problemLocation = ProblemLocation.ofFile(Paths.get(origin, new String[0]));
            } else {
                Path file2 = Path.of(m4.group(1), new String[0]);
                int line = Integer.parseUnsignedInt(m4.group(2));
                problemLocation = ProblemLocation.ofLocationInFile(file2, line);
            }
            problemReporter.report(Problem.builder(problem).location(problemLocation).build());
        }
    }

    @Override
    public void visitFile(PsiFile psiFile, Replacements replacements) {
        ApplyATsVisitor visitor = new ApplyATsVisitor(this.ats, replacements, this.pendingATs, this.logger, this.problemReporter);
        visitor.visitFile(psiFile);
        if (visitor.errored) {
            this.errored = true;
        }
    }

    public static enum AccessTransformerValidation {
        LOG,
        ERROR;

    }
}

