/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.cli.io;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.nio.file.Path;
import java.util.stream.Stream;
import net.neoforged.jst.api.FileEntries;
import net.neoforged.jst.api.FileEntry;
import net.neoforged.jst.api.FileSource;

record SingleFileSource(Path path) implements FileSource,
AutoCloseable
{
    SingleFileSource(Path path) {
        this.path = path.toAbsolutePath();
    }

    @Override
    public VirtualFile createSourceRoot(VirtualFileManager vfsManager) {
        return vfsManager.findFileByNioPath(this.path.getParent());
    }

    @Override
    public Stream<FileEntry> streamEntries() {
        return Stream.of(FileEntries.ofPath(this.path.getParent(), this.path));
    }

    @Override
    public boolean canHaveMultipleEntries() {
        return false;
    }

    @Override
    public boolean isOrdered() {
        return false;
    }
}

