/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.problems;

import java.nio.file.Path;
import java.util.Objects;
import net.neoforged.problems.ProblemId;
import net.neoforged.problems.ProblemLocation;
import net.neoforged.problems.ProblemSeverity;
import org.jetbrains.annotations.Nullable;

public final class Problem {
    private final ProblemId problemId;
    private final ProblemSeverity severity;
    private final ProblemLocation location;
    @Nullable
    private final String contextualLabel;
    @Nullable
    private final String details;
    @Nullable
    private final String solution;
    @Nullable
    private final String documentedAt;

    private Problem(ProblemId problemId, ProblemSeverity severity, @Nullable ProblemLocation location, @Nullable String contextualLabel, @Nullable String details2, @Nullable String solution, @Nullable String documentedAt) {
        this.problemId = Objects.requireNonNull(problemId, "problemId");
        this.severity = Objects.requireNonNull(severity, "severity");
        this.location = location;
        this.contextualLabel = contextualLabel;
        this.details = details2;
        this.solution = solution;
        this.documentedAt = documentedAt;
    }

    public ProblemId problemId() {
        return this.problemId;
    }

    public ProblemSeverity severity() {
        return this.severity;
    }

    @Nullable
    public ProblemLocation location() {
        return this.location;
    }

    @Nullable
    public String contextualLabel() {
        return this.contextualLabel;
    }

    @Nullable
    public String details() {
        return this.details;
    }

    @Nullable
    public String solution() {
        return this.solution;
    }

    @Nullable
    public String documentedAt() {
        return this.documentedAt;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Problem problem = (Problem)o;
        return Objects.equals(this.problemId, problem.problemId) && this.severity == problem.severity && Objects.equals(this.location, problem.location) && Objects.equals(this.contextualLabel, problem.contextualLabel) && Objects.equals(this.details, problem.details) && Objects.equals(this.solution, problem.solution) && Objects.equals(this.documentedAt, problem.documentedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.problemId, this.severity, this.location, this.contextualLabel, this.details, this.solution, this.documentedAt});
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append('[').append((Object)this.severity).append("] ").append(this.problemId);
        if (this.contextualLabel != null) {
            result2.append(": ").append(this.contextualLabel);
        }
        if (this.location != null) {
            result2.append(" @ ").append(this.location);
        }
        return result2.toString();
    }

    public static Builder builder(ProblemId id) {
        return new Builder(id);
    }

    public static Builder builder(Problem problem) {
        return new Builder(problem);
    }

    public static final class Builder {
        private final ProblemId problemId;
        private ProblemSeverity severity;
        private ProblemLocation location;
        @Nullable
        private String contextualLabel;
        @Nullable
        private String details;
        @Nullable
        private String solution;
        @Nullable
        private String documentedAt;

        private Builder(ProblemId problemId) {
            this.problemId = problemId;
            this.severity = ProblemSeverity.WARNING;
        }

        private Builder(Problem problem) {
            this.problemId = problem.problemId;
            this.severity = problem.severity;
            this.location = problem.location;
            this.contextualLabel = problem.contextualLabel;
            this.details = problem.details;
            this.solution = problem.solution;
            this.documentedAt = problem.documentedAt;
        }

        public Builder severity(ProblemSeverity severity) {
            this.severity = severity;
            return this;
        }

        public Builder location(@Nullable ProblemLocation location) {
            this.location = location;
            return this;
        }

        public Builder contextualLabel(@Nullable String contextualLabel) {
            this.contextualLabel = contextualLabel;
            return this;
        }

        public Builder details(@Nullable String details2) {
            this.details = details2;
            return this;
        }

        public Builder solution(@Nullable String solution) {
            this.solution = solution;
            return this;
        }

        public Builder documentedAt(@Nullable String documentedAt) {
            this.documentedAt = documentedAt;
            return this;
        }

        public Builder inFile(Path file2) {
            return this.location(ProblemLocation.ofFile(file2));
        }

        public Builder inFileOnLine(Path file2, int line) {
            return this.location(ProblemLocation.ofLocationInFile(file2, line));
        }

        public Builder inFileOnLine(Path file2, int line, int column) {
            return this.location(ProblemLocation.ofLocationInFile(file2, line, column));
        }

        public Builder inFileOnLine(Path file2, int line, int column, int length) {
            return this.location(ProblemLocation.ofLocationInFile(file2, line, column, length));
        }

        public Builder inFileAtOffset(Path file2, int offset, int length) {
            return this.location(ProblemLocation.ofOffsetInFile(file2, offset, length));
        }

        public Problem build() {
            return new Problem(this.problemId, this.severity, this.location, this.contextualLabel, this.details, this.solution, this.documentedAt);
        }
    }
}

