/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.problems;

import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class ProblemGroup {
    private final String id;
    private final String displayName;
    @Nullable
    private final ProblemGroup parent;

    private ProblemGroup(String id, String displayName) {
        this(id, displayName, null);
    }

    private ProblemGroup(String id, String displayName, @Nullable ProblemGroup parent) {
        this.id = Objects.requireNonNull(id, "id");
        this.displayName = Objects.requireNonNull(displayName, "displayName");
        this.parent = parent;
    }

    public String id() {
        return this.id;
    }

    public String displayName() {
        return this.displayName;
    }

    @Nullable
    public ProblemGroup parent() {
        return this.parent;
    }

    public static ProblemGroup create(String id, String displayName) {
        return ProblemGroup.create(id, displayName, null);
    }

    public static ProblemGroup create(String id, String displayName, @Nullable ProblemGroup parent) {
        return new ProblemGroup(id, displayName, parent);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProblemGroup that = (ProblemGroup)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.parent, that.parent);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.parent);
    }

    public String toString() {
        if (this.parent != null) {
            return this.parent + ":" + this.id;
        }
        return this.id;
    }
}

