/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.xpath.jaxen;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jaxen.BaseXPath;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.UnresolvableException;
import org.jaxen.VariableContext;
import org.jaxen.XPath;
import org.jdom.Namespace;
import org.jdom.filter2.Filter;
import org.jdom.xpath.jaxen.JDOMCoreNavigator;
import org.jdom.xpath.jaxen.NamespaceContainer;
import org.jdom.xpath.util.AbstractXPathCompiled;

final class JaxenCompiled<T>
extends AbstractXPathCompiled<T>
implements NamespaceContext,
VariableContext {
    private final XPath xPath;

    private static Object unWrapNS(Object o) {
        if (o instanceof NamespaceContainer) {
            return ((NamespaceContainer)o).getNamespace();
        }
        return o;
    }

    private static List<Object> unWrap(List<?> results) {
        ArrayList<Object> ret = new ArrayList<Object>(results.size());
        for (Object result2 : results) {
            ret.add(JaxenCompiled.unWrapNS(result2));
        }
        return ret;
    }

    JaxenCompiled(String expression, Filter<T> filter2, Map<String, Object> variables, Namespace[] namespaces) {
        super(expression, filter2, variables, namespaces);
        try {
            JDOMCoreNavigator navigator = new JDOMCoreNavigator();
            this.xPath = new BaseXPath(expression, navigator);
        }
        catch (JaxenException e) {
            throw new IllegalArgumentException("Unable to compile '" + expression + "'. See Cause.", e);
        }
        this.xPath.setNamespaceContext(this);
        this.xPath.setVariableContext(this);
    }

    private JaxenCompiled(JaxenCompiled<T> toclone) {
        this(toclone.getExpression(), toclone.getFilter(), toclone.getVariables(), toclone.getNamespaces());
    }

    @Override
    public String translateNamespacePrefixToUri(String prefix) {
        return this.getNamespace(prefix).getURI();
    }

    @Override
    public Object getVariableValue(String namespaceURI, String prefix, String localName) throws UnresolvableException {
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        if (prefix == null) {
            prefix = "";
        }
        try {
            if (namespaceURI.isEmpty()) {
                namespaceURI = this.getNamespace(prefix).getURI();
            }
            return this.getVariable(localName, Namespace.getNamespace(namespaceURI));
        }
        catch (IllegalArgumentException e) {
            throw new UnresolvableException("Unable to resolve variable " + localName + " in namespace '" + namespaceURI + "' to a vaulue.");
        }
    }

    @Override
    protected List<?> evaluateRawAll(Object context2) {
        try {
            return JaxenCompiled.unWrap(this.xPath.selectNodes(context2));
        }
        catch (JaxenException e) {
            throw new IllegalStateException("Unable to evaluate expression. See cause", e);
        }
    }

    @Override
    protected Object evaluateRawFirst(Object context2) {
        try {
            return JaxenCompiled.unWrapNS(this.xPath.selectSingleNode(context2));
        }
        catch (JaxenException e) {
            throw new IllegalStateException("Unable to evaluate expression. See cause", e);
        }
    }

    @Override
    public JaxenCompiled<T> clone() {
        return new JaxenCompiled<T>(this);
    }
}

