/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.io.gson.metadata;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import org.parchmentmc.feather.metadata.ClassMetadata;
import org.parchmentmc.feather.metadata.ClassMetadataBuilder;
import org.parchmentmc.feather.metadata.FieldMetadata;
import org.parchmentmc.feather.metadata.MethodMetadata;
import org.parchmentmc.feather.metadata.RecordMetadata;
import org.parchmentmc.feather.named.Named;

class ClassMetadataAdapter
extends TypeAdapter<ClassMetadata> {
    private static final TypeToken<LinkedHashSet<Named>> NAMED_Set_TOKEN = new TypeToken<LinkedHashSet<Named>>(){};
    private static final TypeToken<LinkedHashSet<MethodMetadata>> METHOD_METADATA_Set_TOKEN = new TypeToken<LinkedHashSet<MethodMetadata>>(){};
    private static final TypeToken<LinkedHashSet<FieldMetadata>> FIELD_METADATA_Set_TOKEN = new TypeToken<LinkedHashSet<FieldMetadata>>(){};
    private static final TypeToken<LinkedHashSet<RecordMetadata>> RECORD_METADATA_Set_TOKEN = new TypeToken<LinkedHashSet<RecordMetadata>>(){};
    private static final TypeToken<LinkedHashSet<ClassMetadata>> CLASS_METADATA_Set_TOKEN = new TypeToken<LinkedHashSet<ClassMetadata>>(){};
    private final Gson gson;

    public ClassMetadataAdapter(Gson gson) {
        this.gson = gson;
    }

    @Override
    public void write(JsonWriter out, ClassMetadata value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        out.name("name");
        this.gson.toJson((Object)value.getName(), (Type)((Object)Named.class), out);
        out.name("owner");
        this.gson.toJson((Object)value.getOwner(), (Type)((Object)Named.class), out);
        out.name("security").value(value.getSecuritySpecification());
        out.name("extends");
        this.gson.toJson((Object)value.getSuperName(), (Type)((Object)Named.class), out);
        out.name("implements");
        this.gson.toJson(value.getInterfaces(), NAMED_Set_TOKEN.getType(), out);
        out.name("fields");
        this.gson.toJson(value.getFields(), FIELD_METADATA_Set_TOKEN.getType(), out);
        out.name("methods");
        this.gson.toJson(value.getMethods(), METHOD_METADATA_Set_TOKEN.getType(), out);
        out.name("records");
        this.gson.toJson(value.getRecords(), RECORD_METADATA_Set_TOKEN.getType(), out);
        out.name("inner");
        this.gson.toJson(value.getInnerClasses(), CLASS_METADATA_Set_TOKEN.getType(), out);
        out.name("signature");
        this.gson.toJson((Object)value.getSignature(), (Type)((Object)Named.class), out);
        out.name("record").value(value.isRecord());
        out.endObject();
    }

    @Override
    public ClassMetadata read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        Named name = Named.empty();
        Named owner = Named.empty();
        int security = -1;
        Named superName = Named.empty();
        LinkedHashSet interfaces = null;
        LinkedHashSet fields = null;
        LinkedHashSet<MethodMetadata> methods = null;
        LinkedHashSet records = null;
        LinkedHashSet<ClassMetadata> innerClasses = null;
        Named signature = Named.empty();
        boolean isRecord = false;
        in.beginObject();
        block26: while (in.hasNext()) {
            String propertyName;
            switch (propertyName = in.nextName()) {
                case "name": {
                    name = (Named)this.gson.fromJson(in, (Type)((Object)Named.class));
                    continue block26;
                }
                case "owner": {
                    owner = (Named)this.gson.fromJson(in, (Type)((Object)Named.class));
                    continue block26;
                }
                case "security": {
                    security = in.nextInt();
                    continue block26;
                }
                case "extends": {
                    superName = (Named)this.gson.fromJson(in, (Type)((Object)Named.class));
                    continue block26;
                }
                case "implements": {
                    interfaces = (LinkedHashSet)this.gson.fromJson(in, NAMED_Set_TOKEN.getType());
                    continue block26;
                }
                case "fields": {
                    fields = (LinkedHashSet)this.gson.fromJson(in, FIELD_METADATA_Set_TOKEN.getType());
                    continue block26;
                }
                case "records": {
                    records = (LinkedHashSet)this.gson.fromJson(in, RECORD_METADATA_Set_TOKEN.getType());
                    continue block26;
                }
                case "methods": {
                    methods = (LinkedHashSet<MethodMetadata>)this.gson.fromJson(in, METHOD_METADATA_Set_TOKEN.getType());
                    continue block26;
                }
                case "inner": {
                    innerClasses = (LinkedHashSet<ClassMetadata>)this.gson.fromJson(in, CLASS_METADATA_Set_TOKEN.getType());
                    continue block26;
                }
                case "signature": {
                    signature = (Named)this.gson.fromJson(in, (Type)((Object)Named.class));
                    continue block26;
                }
                case "record": {
                    isRecord = in.nextBoolean();
                    continue block26;
                }
            }
            in.skipValue();
        }
        in.endObject();
        if (name.isEmpty()) {
            throw new JsonParseException("Class metadata name is not present or empty");
        }
        if (security == -1) {
            throw new JsonParseException("Class metadata security specification is not present");
        }
        if (interfaces == null) {
            methods = new LinkedHashSet<MethodMetadata>();
        }
        if (fields == null) {
            fields = new LinkedHashSet();
        }
        if (records == null) {
            records = new LinkedHashSet();
        }
        if (methods == null) {
            methods = new LinkedHashSet<MethodMetadata>();
        }
        if (innerClasses == null) {
            innerClasses = new LinkedHashSet<ClassMetadata>();
        }
        if (!records.isEmpty()) {
            isRecord = true;
        }
        return ClassMetadataBuilder.create().withSuperName(superName).withInterfaces(interfaces).withOwner(owner).withMethods(methods).withFields(fields).withInnerClasses(innerClasses).withName(name).withSecuritySpecifications(security).withSignature(signature).withRecords(records).withIsRecord(isRecord).build();
    }
}

