/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.io.gson.metadata;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import org.parchmentmc.feather.metadata.FieldMetadata;
import org.parchmentmc.feather.metadata.FieldMetadataBuilder;
import org.parchmentmc.feather.named.Named;

class FieldMetadataAdapter
extends TypeAdapter<FieldMetadata> {
    private final Gson gson;

    public FieldMetadataAdapter(Gson gson) {
        this.gson = gson;
    }

    @Override
    public void write(JsonWriter out, FieldMetadata value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        out.name("name");
        this.gson.toJson((Object)value.getName(), (Type)((Object)Named.class), out);
        out.name("owner");
        this.gson.toJson((Object)value.getOwner(), (Type)((Object)Named.class), out);
        out.name("security").value(value.getSecuritySpecification());
        out.name("descriptor");
        this.gson.toJson((Object)value.getDescriptor(), (Type)((Object)Named.class), out);
        out.name("signature");
        this.gson.toJson((Object)value.getSignature(), (Type)((Object)Named.class), out);
        out.endObject();
    }

    @Override
    public FieldMetadata read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        Named name = Named.empty();
        Named owner = Named.empty();
        int security = -1;
        Named descriptor2 = Named.empty();
        Named signature = Named.empty();
        in.beginObject();
        block14: while (in.hasNext()) {
            String propertyName;
            switch (propertyName = in.nextName()) {
                case "name": {
                    name = (Named)this.gson.fromJson(in, (Type)((Object)Named.class));
                    continue block14;
                }
                case "owner": {
                    owner = (Named)this.gson.fromJson(in, (Type)((Object)Named.class));
                    continue block14;
                }
                case "security": {
                    security = in.nextInt();
                    continue block14;
                }
                case "descriptor": {
                    descriptor2 = (Named)this.gson.fromJson(in, (Type)((Object)Named.class));
                    continue block14;
                }
                case "signature": {
                    signature = (Named)this.gson.fromJson(in, (Type)((Object)Named.class));
                    continue block14;
                }
            }
            in.skipValue();
        }
        in.endObject();
        if (name.isEmpty()) {
            throw new JsonParseException("Field name is not present or empty");
        }
        if (owner.isEmpty()) {
            throw new JsonParseException("Field owner is not present or empty");
        }
        if (security == -1) {
            throw new JsonParseException("Field security specification is not present");
        }
        if (descriptor2.isEmpty()) {
            throw new JsonParseException("Field descriptor is not present or empty");
        }
        return FieldMetadataBuilder.create().withOwner(owner).withName(name).withSecuritySpecification(security).withSignature(signature).withDescriptor(descriptor2).build();
    }
}

