/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.metadata;

import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.parchmentmc.feather.metadata.BouncingTargetMetadata;
import org.parchmentmc.feather.metadata.ImmutableBouncingTargetMetadata;
import org.parchmentmc.feather.metadata.Reference;
import org.parchmentmc.feather.metadata.ReferenceBuilder;

public class BouncingTargetMetadataBuilder
implements BouncingTargetMetadata {
    private Reference target = null;
    private Reference owner = null;

    public static BouncingTargetMetadataBuilder create() {
        return new BouncingTargetMetadataBuilder();
    }

    public static BouncingTargetMetadataBuilder create(BouncingTargetMetadata bouncingTargetMetadata) {
        if (bouncingTargetMetadata == null) {
            return BouncingTargetMetadataBuilder.create();
        }
        return new BouncingTargetMetadataBuilder(bouncingTargetMetadata.getTarget().orElse(null), bouncingTargetMetadata.getOwner().orElse(null));
    }

    private BouncingTargetMetadataBuilder() {
    }

    private BouncingTargetMetadataBuilder(Reference target, Reference owner) {
        this.target = target;
        this.owner = owner;
    }

    public BouncingTargetMetadataBuilder withTarget(Reference target) {
        this.target = target;
        return this;
    }

    public BouncingTargetMetadataBuilder withOwner(Reference owner) {
        this.owner = owner;
        return this;
    }

    public BouncingTargetMetadataBuilder merge(@Nullable BouncingTargetMetadata source) {
        if (source == null) {
            return this;
        }
        if (source.getTarget().isPresent()) {
            this.target = this.target == null ? source.getTarget().get() : ReferenceBuilder.create(this.target).merge(source.getTarget().get()).build();
        }
        if (source.getOwner().isPresent()) {
            this.owner = this.owner == null ? source.getOwner().get() : ReferenceBuilder.create(this.owner).merge(source.getOwner().get()).build();
        }
        return this;
    }

    @Override
    public Optional<Reference> getTarget() {
        return Optional.ofNullable(this.target);
    }

    @Override
    public Optional<Reference> getOwner() {
        return Optional.ofNullable(this.owner);
    }

    public @NonNull BouncingTargetMetadata build() {
        return new ImmutableBouncingTargetMetadata(this.target, this.owner);
    }

    @Override
    public @NonNull BouncingTargetMetadata toImmutable() {
        return this.build();
    }
}

