/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.metadata;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.parchmentmc.feather.metadata.ClassMetadata;
import org.parchmentmc.feather.metadata.ClassMetadataBuilder;
import org.parchmentmc.feather.metadata.ImmutableSourceMetadata;
import org.parchmentmc.feather.metadata.SourceMetadata;
import org.parchmentmc.feather.named.Named;
import org.parchmentmc.feather.named.NamedBuilder;
import org.parchmentmc.feather.util.CollectorUtils;
import org.parchmentmc.feather.util.HasImmutable;
import org.parchmentmc.feather.util.SimpleVersion;

public final class SourceMetadataBuilder
implements SourceMetadata {
    private SimpleVersion specVersion = SimpleVersion.of(1, 0, 0);
    private String minecraftVersion = "0.0.0";
    private LinkedHashSet<ClassMetadata> classes = new LinkedHashSet();

    private SourceMetadataBuilder() {
    }

    public static SourceMetadataBuilder create() {
        return new SourceMetadataBuilder();
    }

    public static SourceMetadataBuilder create(SourceMetadata target) {
        if (target == null) {
            return SourceMetadataBuilder.create();
        }
        return SourceMetadataBuilder.create().withSpecVersion(target.getSpecificationVersion()).withMinecraftVersion(target.getMinecraftVersion()).withClasses(target.getClasses());
    }

    public SourceMetadataBuilder withSpecVersion(SimpleVersion specVersion) {
        this.specVersion = specVersion;
        return this;
    }

    public SourceMetadataBuilder withMinecraftVersion(String minecraftVersion) {
        this.minecraftVersion = minecraftVersion;
        return this;
    }

    public SourceMetadataBuilder withClasses(LinkedHashSet<ClassMetadata> classes) {
        this.classes = classes;
        return this;
    }

    public SourceMetadataBuilder merge(SourceMetadata source, String mergingSchema) {
        if (source == null) {
            return this;
        }
        Map schemadLocalInnerClasses = this.classes.stream().collect(CollectorUtils.toLinkedMap(fm -> NamedBuilder.create().with(mergingSchema, fm.getName().getName(mergingSchema).orElse("")).build(), Function.identity()));
        Map schemadSourceInnerClasses = source.getClasses().stream().collect(CollectorUtils.toLinkedMap(fm -> NamedBuilder.create().with(mergingSchema, fm.getName().getName(mergingSchema).orElse("")).build(), Function.identity()));
        this.classes = new LinkedHashSet();
        for (Named keyReference : schemadLocalInnerClasses.keySet()) {
            if (!schemadSourceInnerClasses.containsKey(keyReference)) {
                this.classes.add((ClassMetadata)schemadLocalInnerClasses.get(keyReference));
                continue;
            }
            this.classes.add(ClassMetadataBuilder.create((ClassMetadata)schemadLocalInnerClasses.get(keyReference)).merge((ClassMetadata)schemadSourceInnerClasses.get(keyReference), mergingSchema).build());
        }
        schemadSourceInnerClasses.keySet().stream().filter(mr -> !schemadLocalInnerClasses.containsKey(mr)).forEach(mr -> this.classes.add((ClassMetadata)schemadSourceInnerClasses.get(mr)));
        return this;
    }

    @Override
    public SimpleVersion getSpecificationVersion() {
        return this.specVersion;
    }

    @Override
    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    @Override
    public LinkedHashSet<ClassMetadata> getClasses() {
        return this.classes;
    }

    public ImmutableSourceMetadata build() {
        return new ImmutableSourceMetadata(this.specVersion, this.minecraftVersion, this.classes.stream().map(HasImmutable::toImmutable).collect(CollectorUtils.toLinkedSet()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SourceMetadata)) {
            return false;
        }
        SourceMetadata that = (SourceMetadata)o;
        return this.getSpecificationVersion().equals(that.getSpecificationVersion()) && this.getMinecraftVersion().equals(that.getMinecraftVersion()) && this.getClasses().equals(that.getClasses());
    }

    public int hashCode() {
        return Objects.hash(this.getSpecificationVersion(), this.getMinecraftVersion(), this.getClasses());
    }

    public SourceMetadataBuilder addClass(ClassMetadata build) {
        this.classes.add(build);
        return this;
    }

    @Override
    public @NonNull SourceMetadata toImmutable() {
        return this.build();
    }
}

