/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.named;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.parchmentmc.feather.named.ImmutableNamed;
import org.parchmentmc.feather.named.Named;

public class NamedBuilder
implements Named {
    private final Map<String, String> names = Maps.newLinkedHashMap();

    public static NamedBuilder create(String mappingName, String mappingValue) {
        if (mappingName == null || mappingValue == null) {
            return NamedBuilder.create();
        }
        return new NamedBuilder(mappingName, mappingValue);
    }

    public static NamedBuilder create(Map<String, String> names) {
        if (names == null) {
            return NamedBuilder.create();
        }
        return new NamedBuilder(names);
    }

    public static NamedBuilder create(Named named) {
        if (named == null) {
            return NamedBuilder.create();
        }
        return new NamedBuilder(named);
    }

    public static NamedBuilder create() {
        return new NamedBuilder();
    }

    private NamedBuilder(String mappingName, String mappingValue) {
        this.names.put(mappingName, mappingValue);
    }

    private NamedBuilder(Map<String, String> names) {
        this.names.putAll(names);
    }

    private NamedBuilder(Named named) {
        this.names.putAll(named.getNames());
    }

    private NamedBuilder() {
    }

    @Override
    public Map<String, String> getNames() {
        return this.names;
    }

    public NamedBuilder with(String scheme, String name) {
        if (scheme.equals("") || name.equals("")) {
            return this;
        }
        this.names.put(scheme, name);
        return this;
    }

    public NamedBuilder withObfuscated(String name) {
        return this.with("obf", name);
    }

    public NamedBuilder withMojang(String name) {
        return this.with("moj", name);
    }

    public NamedBuilder merge(Named source) {
        if (source == null) {
            return this;
        }
        this.names.putAll(source.getNames());
        return this;
    }

    public Named build() {
        return this.names.isEmpty() ? ImmutableNamed.empty() : ImmutableNamed.of(this.names);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Named)) {
            return false;
        }
        Named that = (Named)o;
        return this.getNames().equals(that.getNames());
    }

    public int hashCode() {
        return Objects.hash(this.getNames());
    }

    @Override
    public @NonNull Named toImmutable() {
        return this.build();
    }
}

