/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.changedata;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.neoremind.fountain.changedata.BinlogTraceable;
import net.neoremind.fountain.event.data.RowData;
import net.neoremind.fountain.eventposition.SyncPoint;
import net.neoremind.fountain.meta.ColumnMeta;

public class ChangeDataSet
implements BinlogTraceable {
    private BigInteger gtId;
    private String instanceName;
    private Map<String, List<ColumnMeta>> tableDef = new LinkedHashMap<String, List<ColumnMeta>>();
    private Map<String, List<RowData>> tableData = new LinkedHashMap<String, List<RowData>>();
    private long birthTime;
    private long sendTime;
    private transient SyncPoint syncPoint;
    private String srcDbHost;
    private int dataSize = 0;

    public ChangeDataSet() {
        this.syncPoint = null;
    }

    public ChangeDataSet(SyncPoint syncPoint, String instanceName) {
        this.syncPoint = syncPoint;
        this.instanceName = instanceName;
    }

    public List<ColumnMeta> getColumnMetaByFullTableName(String tableFullName) {
        return this.tableDef.get(tableFullName);
    }

    public List<RowData> getTableRowDatasByFullTableName(String tableFullName) {
        return this.tableData.get(tableFullName);
    }

    public List<String> getTableNameList() {
        ArrayList<String> nameList = new ArrayList<String>(this.tableDef.size());
        nameList.addAll(this.tableDef.keySet());
        return nameList;
    }

    public String toString() {
        return "ChangeDataSet{gtId=" + this.gtId + ", instanceName='" + this.instanceName + '\'' + ", srcDbHost='" + this.srcDbHost + '\'' + ", dataSize=" + this.dataSize + ", syncPoint=" + this.syncPoint + ", birthTime=" + this.birthTime + ", sendTime=" + this.sendTime + '}';
    }

    @Override
    public SyncPoint getSyncPoint() {
        return this.syncPoint;
    }

    @Override
    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    @Override
    public int getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(int dataSize) {
        this.dataSize = dataSize;
    }

    public void setSyncPoint(SyncPoint syncPoint) {
        this.syncPoint = syncPoint;
    }

    public String getSrcDbHost() {
        return this.srcDbHost;
    }

    public void setSrcDbHost(String srcDbHost) {
        this.srcDbHost = srcDbHost;
    }

    public long getSendTime() {
        return this.sendTime;
    }

    public void setSendTime(long sendTime) {
        this.sendTime = sendTime;
    }

    public BigInteger getGtId() {
        return this.gtId;
    }

    public void setGtId(BigInteger gtId) {
        this.gtId = gtId;
    }

    public Map<String, List<ColumnMeta>> getTableDef() {
        return this.tableDef;
    }

    public void setTableDef(Map<String, List<ColumnMeta>> tableDef) {
        this.tableDef = tableDef;
    }

    public Map<String, List<RowData>> getTableData() {
        return this.tableData;
    }

    public void setTableData(Map<String, List<RowData>> tableData) {
        this.tableData = tableData;
    }

    public long getBirthTime() {
        return this.birthTime;
    }

    public void setBirthTime(long birthTime) {
        this.birthTime = birthTime;
    }
}

