/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.changedata.pb;

import com.google.protobuf.ByteString;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.neoremind.fountain.changedata.ChangeDataSet;
import net.neoremind.fountain.changedata.pb.DataUnitDef;
import net.neoremind.fountain.event.data.ColumnData;
import net.neoremind.fountain.event.data.RowData;
import net.neoremind.fountain.meta.ColumnMeta;

public class ProtoUtils {
    private static final int OP_INSERT = 0;
    private static final int OP_UPDATE = 1;
    private static final int OP_DELETE = 2;

    private ProtoUtils() {
    }

    public static DataUnitDef.DataSet convert2Pb(ChangeDataSet changeSet) {
        DataUnitDef.DataSet.Builder dsBuilder = DataUnitDef.DataSet.newBuilder();
        dsBuilder.setGtId(changeSet.getGtId() == null ? -1L : changeSet.getGtId().longValue());
        dsBuilder.addAllTables(ProtoUtils.extractTableData(changeSet));
        return dsBuilder.build();
    }

    private static List<DataUnitDef.TableData> extractTableData(ChangeDataSet changeSet) {
        ArrayList<DataUnitDef.TableData> list = new ArrayList<DataUnitDef.TableData>(changeSet.getTableDef().size());
        for (String tableName : changeSet.getTableData().keySet()) {
            List<RowData> rowList = changeSet.getTableData().get(tableName);
            DataUnitDef.TableData.Builder builder = DataUnitDef.TableData.newBuilder();
            builder.setName(tableName);
            builder.addAllColumnMeta(ProtoUtils.extractColumnMeta(changeSet.getTableDef().get(tableName)));
            for (RowData rd : rowList) {
                builder.addRows(ProtoUtils.extractRow(rd, changeSet.getTableDef().get(tableName)));
            }
            list.add(builder.build());
        }
        return list;
    }

    private static List<DataUnitDef.ColumnMeta> extractColumnMeta(List<ColumnMeta> metaList) {
        ArrayList<DataUnitDef.ColumnMeta> list = new ArrayList<DataUnitDef.ColumnMeta>(metaList.size());
        for (ColumnMeta meta : metaList) {
            DataUnitDef.ColumnMeta.Builder builder = DataUnitDef.ColumnMeta.newBuilder();
            builder.setName(meta.getColumnName());
            builder.setDataType(meta.getTypeEnum().getTypeValue());
            builder.setIsNull(meta.isNullable());
            builder.setIsUnsiged(meta.isUnsigned());
            builder.setIsPrimay(false);
            list.add(builder.build());
        }
        return list;
    }

    private static DataUnitDef.RowData extractRow(RowData originalRow, List<ColumnMeta> metaList) {
        DataUnitDef.RowData.Builder builder = DataUnitDef.RowData.newBuilder();
        if (originalRow.isWrite()) {
            builder.setOptype(0);
            builder.addAllAfterValues(ProtoUtils.extractColumnValues(originalRow.getAfterColumnList(), metaList));
        }
        if (originalRow.isUpdate()) {
            builder.setOptype(1);
            builder.addAllAfterValues(ProtoUtils.extractColumnValues(originalRow.getAfterColumnList(), metaList));
            builder.addAllBeforeValues(ProtoUtils.extractColumnValues(originalRow.getBeforeColumnList(), metaList));
        }
        if (originalRow.isDelete()) {
            builder.setOptype(2);
            builder.addAllBeforeValues(ProtoUtils.extractColumnValues(originalRow.getBeforeColumnList(), metaList));
        }
        return builder.build();
    }

    private static List<DataUnitDef.ColumnValue> extractColumnValues(List<ColumnData> dataList, List<ColumnMeta> metaList) {
        ArrayList<DataUnitDef.ColumnValue> list = new ArrayList<DataUnitDef.ColumnValue>(metaList.size());
        int index = 0;
        for (ColumnData data : dataList) {
            DataUnitDef.ColumnValue.Builder builder = DataUnitDef.ColumnValue.newBuilder();
            ColumnMeta meta = metaList.get(index++);
            if (data.isNull()) {
                builder.setIsNull(true);
            } else {
                ProtoUtils.applyValue(builder, data.getValue(), meta);
            }
            list.add(builder.build());
        }
        return list;
    }

    private static void applyValue(DataUnitDef.ColumnValue.Builder builder, Object value, ColumnMeta meta) {
        switch (meta.getTypeEnum()) {
            case MYSQL_TYPE_DECIMAL: {
                builder.setStringValue(value.toString());
                break;
            }
            case MYSQL_TYPE_NEWDECIMAL: {
                builder.setStringValue(value.toString());
                break;
            }
            case MYSQL_TYPE_TINY: {
                builder.setIntValue(((Byte)value).byteValue());
                break;
            }
            case MYSQL_TYPE_SHORT: {
                builder.setIntValue((Integer)value);
                break;
            }
            case MYSQL_TYPE_INT24: {
                builder.setIntValue((Integer)value);
                break;
            }
            case MYSQL_TYPE_LONG: {
                if (value instanceof Long) {
                    builder.setIntValue(((Long)value).intValue());
                    break;
                }
                builder.setIntValue((Integer)value);
                break;
            }
            case MYSQL_TYPE_FLOAT: {
                builder.setFloatValue(((Float)value).floatValue());
                break;
            }
            case MYSQL_TYPE_DOUBLE: {
                builder.setDoubleValue((Double)value);
                break;
            }
            case MYSQL_TYPE_LONGLONG: {
                if (value instanceof BigInteger) {
                    builder.setLongValue(((BigInteger)value).longValue());
                    break;
                }
                builder.setLongValue((Long)value);
                break;
            }
            case MYSQL_TYPE_DATE: {
                builder.setLongValue(((Date)value).getTime());
                break;
            }
            case MYSQL_TYPE_DATETIME: {
                builder.setLongValue(((Date)value).getTime());
                break;
            }
            case MYSQL_TYPE_NEWDATE: {
                builder.setLongValue(((Date)value).getTime());
                break;
            }
            case MYSQL_TYPE_VARCHAR: {
                builder.setStringValue(value.toString());
                break;
            }
            case MYSQL_TYPE_BIT: {
                builder.setBoolValue((Boolean)value);
                break;
            }
            case MYSQL_TYPE_STRING: {
                builder.setStringValue(value.toString());
                break;
            }
            case MYSQL_TYPE_TINY_BLOB: {
                builder.setByteArrayValue(ByteString.copyFrom((byte[])((byte[])value)));
                break;
            }
            case MYSQL_TYPE_MEDIUM_BLOB: {
                builder.setByteArrayValue(ByteString.copyFrom((byte[])((byte[])value)));
                break;
            }
            case MYSQL_TYPE_LONG_BLOB: {
                builder.setByteArrayValue(ByteString.copyFrom((byte[])((byte[])value)));
                break;
            }
            case MYSQL_TYPE_BLOB: {
                if (value instanceof String) {
                    builder.setStringValue(value.toString());
                    break;
                }
                builder.setByteArrayValue(ByteString.copyFrom((byte[])((byte[])value)));
                break;
            }
        }
    }
}

