/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.datasource;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import net.neoremind.fountain.datasource.DatasourceChooseCallbackHandler;
import net.neoremind.fountain.datasource.DatasourceChoosePolicy;
import net.neoremind.fountain.datasource.MysqlDataSource;
import net.neoremind.fountain.datasource.TaskExcutor;
import net.neoremind.fountain.exception.DataSourceInvalidException;
import net.neoremind.fountain.meta.TableMeta;
import net.neoremind.fountain.packet.OKPacket;
import net.neoremind.fountain.packet.ResultSetPacket;
import net.neoremind.fountain.util.CollectionUtils;
import org.slf4j.Logger;

public abstract class AbstractHADatasource<T extends MysqlDataSource>
implements MysqlDataSource {
    protected List<T> mysqlDataSourceList;
    protected volatile T currentDataSource;
    protected DatasourceChoosePolicy datasourceChoosePolicy;

    public List<T> getMysqlDataSourceList() {
        return this.mysqlDataSourceList;
    }

    public void setMysqlDataSourceList(List<T> mysqlDataSourceList) {
        this.mysqlDataSourceList = mysqlDataSourceList;
    }

    public DatasourceChoosePolicy getDatasourceChoosePolicy() {
        return this.datasourceChoosePolicy;
    }

    public void setDatasourceChoosePolicy(DatasourceChoosePolicy datasourceChoosePolicy) {
        this.datasourceChoosePolicy = datasourceChoosePolicy;
    }

    protected abstract <E> E doHaTask(String var1, String var2, TaskExcutor<E> var3) throws NoSuchAlgorithmException, IOException;

    protected abstract void prepareChoosedDatasouce(T var1) throws IOException, NoSuchAlgorithmException, TimeoutException;

    protected abstract Logger getLogger();

    @Override
    public void open() throws IOException, NoSuchAlgorithmException, TimeoutException {
        this.checkDataSourceListEmpty();
        this.chooseMysqlDataSource();
    }

    @Override
    public boolean isOpen() {
        return this.currentDataSource != null && this.currentDataSource.isOpen();
    }

    @Override
    public void close() {
        this.getLogger().info("Try to close HA MysqlDataSource ...");
        if (this.mysqlDataSourceList == null) {
            return;
        }
        for (MysqlDataSource dataSource : this.mysqlDataSourceList) {
            if (dataSource == null) continue;
            dataSource.close();
        }
    }

    @Override
    public String getIpAddress() {
        return this.currentDataSource == null ? null : this.currentDataSource.getIpAddress();
    }

    @Override
    public int getPort() {
        return this.currentDataSource == null ? 0 : this.currentDataSource.getPort();
    }

    @Override
    public OKPacket update(String query) throws IOException, NoSuchAlgorithmException {
        return this.doHaTask(query, "update", new TaskExcutor<OKPacket>(){

            @Override
            public OKPacket execute(String command, MysqlDataSource dataSouce) throws Exception {
                return dataSouce.update(command);
            }
        });
    }

    @Override
    public ResultSetPacket query(String query) throws IOException, NoSuchAlgorithmException {
        return this.doHaTask(query, "query", new TaskExcutor<ResultSetPacket>(){

            @Override
            public ResultSetPacket execute(String command, MysqlDataSource dataSouce) throws Exception {
                return dataSouce.query(command);
            }
        });
    }

    @Override
    public TableMeta queryTableMeta(String tableFullName) throws IOException, NoSuchAlgorithmException {
        return this.doHaTask(tableFullName, "queryTableMeta", new TaskExcutor<TableMeta>(){

            @Override
            public TableMeta execute(String command, MysqlDataSource dataSouce) throws Exception {
                return dataSouce.queryTableMeta(command);
            }
        });
    }

    protected void checkDataSourceListEmpty() throws DataSourceInvalidException {
        if (CollectionUtils.isEmpty(this.mysqlDataSourceList)) {
            throw new DataSourceInvalidException("mysqlDataSourceList is empty");
        }
    }

    protected void chooseMysqlDataSource() throws IOException, NoSuchAlgorithmException {
        T bak = this.currentDataSource;
        this.safeCloseCurrent();
        this.currentDataSource = this.recconectCurrent(bak);
        if (this.currentDataSource != null) {
            return;
        }
        this.currentDataSource = this.datasourceChoosePolicy.choose(this.mysqlDataSourceList, new DatasourceChooseCallbackHandler<T>(){

            @Override
            public void doCallback(T choosedDattasource) throws IOException, NoSuchAlgorithmException, TimeoutException {
                if (!choosedDattasource.isOpen()) {
                    StringBuffer sb = new StringBuffer("Choose new dataSource, [ip, port] is [").append(choosedDattasource.getIpAddress()).append(", ").append(choosedDattasource.getPort()).append("]");
                    AbstractHADatasource.this.getLogger().info(sb.toString());
                    AbstractHADatasource.this.prepareChoosedDatasouce(choosedDattasource);
                }
            }

            @Override
            public void logError(Exception e) {
                AbstractHADatasource.this.getLogger().error(null, (Throwable)e);
            }
        });
    }

    private T recconectCurrent(T ds) {
        if (ds == null) {
            return ds;
        }
        this.getLogger().info("Reconnect current datasource {}:{}", (Object)ds.getIpAddress(), (Object)ds.getPort());
        try {
            this.prepareChoosedDatasouce(ds);
            return ds;
        }
        catch (NoSuchAlgorithmException e) {
            this.getLogger().error(null, (Throwable)e);
        }
        catch (IOException e) {
            this.getLogger().error(null, (Throwable)e);
        }
        catch (TimeoutException e) {
            this.getLogger().error(null, (Throwable)e);
        }
        return null;
    }

    protected void safeCloseCurrent() {
        if (this.currentDataSource != null) {
            StringBuffer sb = new StringBuffer("DataSource is invalid and try to close, [ip, port] is [").append(this.currentDataSource.getIpAddress()).append(", ").append(this.currentDataSource.getPort()).append("]");
            this.getLogger().warn(sb.toString());
            this.currentDataSource.close();
            this.currentDataSource = null;
        } else {
            this.getLogger().info("CurrentMysqlDataSource is null, pass closing");
        }
    }
}

