/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.datasource;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import net.neoremind.fountain.datasource.DatasourceConfigure;
import net.neoremind.fountain.datasource.MysqlDataSource;
import net.neoremind.fountain.exception.DataErrorException;
import net.neoremind.fountain.exception.DataSourceInvalidException;
import net.neoremind.fountain.meta.ColumnMeta;
import net.neoremind.fountain.meta.TableMeta;
import net.neoremind.fountain.packet.ClientAuthPacket;
import net.neoremind.fountain.packet.EOFPacket;
import net.neoremind.fountain.packet.ErrorPacket;
import net.neoremind.fountain.packet.FieldDescriptionPacket;
import net.neoremind.fountain.packet.HandshakePacket;
import net.neoremind.fountain.packet.OKPacket;
import net.neoremind.fountain.packet.PacketHeader;
import net.neoremind.fountain.packet.QueryCommandPacket;
import net.neoremind.fountain.packet.ResultSetHeaderPacket;
import net.neoremind.fountain.packet.ResultSetPacket;
import net.neoremind.fountain.packet.RowValuePacket;
import net.neoremind.fountain.util.CollectionUtils;
import net.neoremind.fountain.util.ProtocolHelper;
import net.neoremind.fountain.util.SocketHelper;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMysqlDataSource
implements MysqlDataSource {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMysqlDataSource.class);
    protected DatasourceConfigure conf = new DatasourceConfigure();

    protected abstract Logger getLogger();

    protected abstract Socket createQuerySocket();

    protected abstract void applySocket(Socket var1);

    @Override
    public void open() throws IOException, NoSuchAlgorithmException, TimeoutException {
        this.printMysqlInfo();
        if (this.isOpen()) {
            this.getLogger().warn("dataSource is already open");
            return;
        }
        this.applySocket(this.updateSettings(this.getNewSocket()));
        this.getLogger().warn("Open socket stream to MySQL server done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OKPacket update(String query) throws IOException {
        this.getLogger().info("Update sql: " + query);
        Socket querySocket = this.createQuerySocket();
        try {
            OKPacket oKPacket = this.update(querySocket, query);
            return oKPacket;
        }
        finally {
            IOUtils.closeQuietly((Socket)querySocket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetPacket query(String query) throws IOException {
        this.getLogger().info("Query sql: " + query);
        Socket querySocket = this.createQuerySocket();
        try {
            ResultSetPacket resultSetPacket = this.query(querySocket, query);
            return resultSetPacket;
        }
        finally {
            IOUtils.closeQuietly((Socket)querySocket);
        }
    }

    private ResultSetPacket query(Socket socket, String query) throws IOException {
        if (socket == null || query == null) {
            throw new DataSourceInvalidException("dataSource is not open or query is null");
        }
        byte[] data = this.sendRequestAndGetResponse(socket, query);
        ResultSetHeaderPacket resultSetHeaderPacket = new ResultSetHeaderPacket();
        resultSetHeaderPacket.fromBytes(data);
        ArrayList<FieldDescriptionPacket> fieldPacketList = new ArrayList<FieldDescriptionPacket>();
        int i = 0;
        while ((long)i < resultSetHeaderPacket.getColumnCount()) {
            data = this.readPacket(socket);
            FieldDescriptionPacket fieldPacket = new FieldDescriptionPacket();
            fieldPacket.fromBytes(data);
            fieldPacketList.add(fieldPacket);
            ++i;
        }
        this.readEofPacket(socket);
        ArrayList<RowValuePacket> rowDataPacketList = new ArrayList<RowValuePacket>();
        while ((data = this.readPacket(socket))[0] != -2) {
            RowValuePacket rowDataPacket = new RowValuePacket();
            rowDataPacket.fromBytes(data);
            rowDataPacketList.add(rowDataPacket);
        }
        ResultSetPacket resultSet = new ResultSetPacket();
        resultSet.getFieldDescriptionList().addAll(fieldPacketList);
        for (RowValuePacket row : rowDataPacketList) {
            resultSet.getRowValueList().add(row);
        }
        return resultSet;
    }

    @Override
    public TableMeta queryTableMeta(String tableFullName) throws IOException, NoSuchAlgorithmException {
        ResultSetPacket resultSetPacket = this.query("show full fields from " + tableFullName);
        if (resultSetPacket == null) {
            throw new IOException("Can not query table meta");
        }
        List<FieldDescriptionPacket> fieldDescriptionList = resultSetPacket.getFieldDescriptionList();
        List<RowValuePacket> rowValueList = resultSetPacket.getRowValueList();
        if (CollectionUtils.isEmpty(fieldDescriptionList) || CollectionUtils.isEmpty(rowValueList)) {
            throw new DataErrorException("Query table meta error");
        }
        TableMeta tableMeta = new TableMeta();
        tableMeta.setFullName(tableFullName);
        ArrayList<ColumnMeta> columnMetaList = new ArrayList<ColumnMeta>();
        tableMeta.setColumnMetaList(columnMetaList);
        for (RowValuePacket rowPacket : rowValueList) {
            List<String> fieldValueList = rowPacket.getFieldValueList();
            if (CollectionUtils.isEmpty(fieldValueList) || fieldValueList.size() != 9) {
                logger.warn("do not match desc table's desc");
                continue;
            }
            ColumnMeta columnMeta = new ColumnMeta();
            columnMetaList.add(columnMeta);
            columnMeta.setColumnName(fieldValueList.get(0));
            columnMeta.setColumnType(fieldValueList.get(1));
            columnMeta.setCharset(fieldValueList.get(2));
            columnMeta.setNullFlag(fieldValueList.get(3));
            columnMeta.setKeyFlag(fieldValueList.get(4));
            columnMeta.setDefaultValue(fieldValueList.get(5));
            columnMeta.setExtra(fieldValueList.get(6));
        }
        return tableMeta;
    }

    @Override
    public String getIpAddress() {
        return this.conf.getMysqlServer();
    }

    @Override
    public int getPort() {
        return this.conf.getMysqlPort();
    }

    protected void closeSocket(Socket socket) {
        if (socket != null) {
            this.logClose(socket);
            IOUtils.closeQuietly((Socket)socket);
        }
    }

    protected void printMysqlInfo() throws IOException {
        this.getLogger().info("----- print mysql info ");
        this.getLogger().info(this.conf.toString());
    }

    protected Socket getNewSocket() throws IOException, NoSuchAlgorithmException, TimeoutException {
        Socket socket = new Socket();
        socket.setKeepAlive(true);
        socket.setReuseAddress(true);
        socket.setSoTimeout(this.conf.getSoTimeout());
        socket.setTcpNoDelay(true);
        socket.setReceiveBufferSize(this.conf.getReceiveBufferSize());
        socket.setSendBufferSize(this.conf.getSendBufferSize());
        InetSocketAddress address = new InetSocketAddress(this.conf.getMysqlServer(), this.conf.getMysqlPort());
        try {
            socket.connect(address, this.conf.getConnectTimeout());
        }
        catch (SocketTimeoutException e) {
            IOUtils.closeQuietly((Socket)socket);
            throw e;
        }
        catch (IOException e) {
            IOUtils.closeQuietly((Socket)socket);
            throw e;
        }
        HandshakePacket handshakePacket = this.handshake(socket);
        this.clientAuthorise(socket, handshakePacket);
        return socket;
    }

    protected OKPacket update(Socket socket, String query) throws IOException {
        if (socket == null || query == null) {
            throw new DataSourceInvalidException("dataSource is not open or query is null");
        }
        byte[] data = this.sendRequestAndGetResponse(socket, query);
        OKPacket packet = new OKPacket();
        packet.fromBytes(data);
        return packet;
    }

    protected Socket updateSettings(Socket socket) throws IOException {
        this.getLogger().debug("update MySQL socket params...");
        try {
            this.getLogger().debug("set wait_timeout = " + this.conf.getWaitTimeout());
            this.update(socket, "set wait_timeout=" + this.conf.getWaitTimeout());
        }
        catch (Exception e) {
            this.getLogger().warn(null, (Throwable)e);
        }
        try {
            this.getLogger().debug("set net_write_timeout = " + this.conf.getNetWriteTimeout());
            this.update(socket, "set net_write_timeout=" + this.conf.getNetWriteTimeout());
        }
        catch (Exception e) {
            this.getLogger().warn(null, (Throwable)e);
        }
        try {
            this.getLogger().debug("set net_read_timeout = " + this.conf.getNetReadTimeout());
            this.update(socket, "set net_read_timeout=" + this.conf.getNetReadTimeout());
        }
        catch (Exception e) {
            this.getLogger().warn(null, (Throwable)e);
        }
        try {
            this.getLogger().debug("set charset = " + this.conf.getCharset());
            this.update(socket, "set names '" + this.conf.getCharset() + "'");
        }
        catch (Exception e) {
            this.getLogger().warn(null, (Throwable)e);
        }
        return socket;
    }

    private void logClose(Socket socket) {
        StringBuffer sb = new StringBuffer("Close MySQL datasource, [ip, port] is [").append(socket.getInetAddress()).append(", ").append(socket.getPort()).append("].");
        this.getLogger().info(sb.toString());
    }

    private HandshakePacket handshake(Socket socket) throws IOException {
        byte[] data = SocketHelper.getBuffer(socket, 4);
        PacketHeader header = ProtocolHelper.getProtocolHeader(data);
        if ((data = SocketHelper.getBuffer(socket, header.getPacketLength())) == null || data.length <= 0) {
            throw new DataErrorException("data is null or empty");
        }
        if (data[0] == -1 || data[0] == -2) {
            ErrorPacket errorPacket = new ErrorPacket();
            errorPacket.fromBytes(data);
            throw new DataErrorException("Receive Error Packet! first byte is " + data[0] + ", detail is " + errorPacket.toString());
        }
        HandshakePacket handshakePacket = new HandshakePacket();
        handshakePacket.fromBytes(data);
        return handshakePacket;
    }

    private void clientAuthorise(Socket socket, HandshakePacket handshakePacket) throws IOException, NoSuchAlgorithmException {
        ClientAuthPacket clientAuthPacket = new ClientAuthPacket();
        clientAuthPacket.setUsername(this.conf.getUserName());
        clientAuthPacket.setPassword(this.conf.getPassword());
        clientAuthPacket.setDatabaseName(this.conf.getDatabaseName());
        clientAuthPacket.setCharsetNumber((byte)33);
        clientAuthPacket.setScrumbleBuff(handshakePacket.getScrambleBuff());
        byte[] clientAuthPacketBody = clientAuthPacket.toBytes();
        PacketHeader header = new PacketHeader();
        header.setPacketLength(clientAuthPacketBody.length);
        header.setPacketNumber((byte)(header.getPacketNumber() + 1));
        SocketHelper.writeByte(socket, header.toBytes());
        SocketHelper.writeByte(socket, clientAuthPacketBody);
        byte[] data = SocketHelper.getBuffer(socket, 4);
        header = ProtocolHelper.getProtocolHeader(data);
        data = SocketHelper.getBuffer(socket, header.getPacketLength());
        if ((data[0] & 0xFF) == 255) {
            ErrorPacket errorPacket = new ErrorPacket();
            errorPacket.fromBytes(data);
            throw new IOException("Error When doing Client Authentication:" + errorPacket.getErrorCode() + ", " + errorPacket.getMessage());
        }
        if ((data[0] & 0xFF) == 254) {
            EOFPacket eof = new EOFPacket();
            eof.fromBytes(data);
            throw new IOException("Eof When doing Client Authentication:" + eof.getEofFlag());
        }
    }

    private byte[] sendRequestAndGetResponse(Socket socket, String query) throws IOException {
        QueryCommandPacket queryPacket = new QueryCommandPacket();
        queryPacket.setSql(query);
        byte[] queryPacketBody = queryPacket.toBytes();
        PacketHeader header = new PacketHeader();
        header.setPacketLength(queryPacketBody.length);
        header.setPacketNumber((byte)0);
        SocketHelper.writeByte(socket, header.toBytes());
        SocketHelper.writeByte(socket, queryPacketBody);
        byte[] data = this.readPacket(socket);
        if (data[0] < 0) {
            ErrorPacket errorPacket = new ErrorPacket();
            errorPacket.fromBytes(data);
            throw new IOException("error when execute sql of [" + query + "], error code is :" + errorPacket.getErrorCode() + ", " + errorPacket.getMessage());
        }
        return data;
    }

    private byte[] readPacket(Socket socket) throws IOException {
        byte[] data = SocketHelper.getBuffer(socket, 4);
        PacketHeader header = ProtocolHelper.getProtocolHeader(data);
        data = SocketHelper.getBuffer(socket, header.getPacketLength());
        return data;
    }

    private void readEofPacket(Socket socket) throws IOException {
        byte[] eofBody = this.readPacket(socket);
        if (eofBody[0] != -2) {
            throw new IOException("EOF Packet is expected, but packet with field_count=" + eofBody[0] + " is found.");
        }
    }

    public DatasourceConfigure getConf() {
        return this.conf;
    }

    public void setConf(DatasourceConfigure conf) {
        this.conf = conf;
    }
}

