/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.datasource;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeoutException;
import net.neoremind.fountain.datasource.AbstractHADatasource;
import net.neoremind.fountain.datasource.MysqlDataSource;
import net.neoremind.fountain.datasource.TaskExcutor;
import net.neoremind.fountain.exception.DataSourceInvalidException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HANormalMysqlDataSource
extends AbstractHADatasource<MysqlDataSource>
implements MysqlDataSource {
    private static final Logger logger = LoggerFactory.getLogger(HANormalMysqlDataSource.class);

    @Override
    protected <T> T doHaTask(String command, String method, TaskExcutor<T> taskExecutor) throws NoSuchAlgorithmException, IOException {
        this.checkDataSourceListEmpty();
        for (int i = 0; i < this.mysqlDataSourceList.size(); ++i) {
            try {
                return taskExecutor.execute(command, this.currentDataSource);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.chooseMysqlDataSource();
                continue;
            }
        }
        throw new DataSourceInvalidException("all dataSources are not valid for " + method);
    }

    @Override
    protected void prepareChoosedDatasouce(MysqlDataSource choosedDattasource) throws IOException, NoSuchAlgorithmException, TimeoutException {
        choosedDattasource.open();
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}

