/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.datasource;

import java.util.List;
import net.neoremind.fountain.datasource.DatasourceChooseCallbackHandler;
import net.neoremind.fountain.datasource.DatasourceChoosePolicy;
import net.neoremind.fountain.datasource.MysqlDataSource;
import net.neoremind.fountain.exception.DataSourceInvalidException;
import net.neoremind.fountain.thread.annotaion.UnThreadSafe;

@UnThreadSafe
public class RoundRobinDatasourceChoosePolicy
implements DatasourceChoosePolicy {
    private int index;
    private long tryInterval = 0L;

    @Override
    public <T extends MysqlDataSource> T choose(List<T> datasourceList, DatasourceChooseCallbackHandler<T> callbackHandler) {
        if (this.tryInterval > 0L) {
            try {
                Thread.sleep(this.tryInterval);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        for (int i = 0; i < datasourceList.size(); ++i) {
            MysqlDataSource nextDs = (MysqlDataSource)this.getNextDatasouce(datasourceList);
            try {
                callbackHandler.doCallback(nextDs);
                return (T)nextDs;
            }
            catch (Exception e) {
                callbackHandler.logError(e);
                continue;
            }
        }
        throw new DataSourceInvalidException("All dataSources are not valid");
    }

    private <T> T getNextDatasouce(List<T> datasourceList) {
        if (this.index >= datasourceList.size()) {
            this.index = 0;
        }
        int pos = this.index++ % datasourceList.size();
        return datasourceList.get(pos);
    }

    public long getTryInterval() {
        return this.tryInterval;
    }

    public void setTryInterval(long tryInterval) {
        this.tryInterval = tryInterval;
    }
}

