/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.eventposition;

import java.nio.ByteBuffer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.neoremind.fountain.eventposition.AbstractProxyDisposeEventPosition;
import net.neoremind.fountain.eventposition.DisposeEventPosition;
import net.neoremind.fountain.eventposition.DisposeEventPositionBridge;
import net.neoremind.fountain.eventposition.SyncPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncFixedRateDisposeEventPosition
extends AbstractProxyDisposeEventPosition
implements DisposeEventPosition {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncFixedRateDisposeEventPosition.class);
    private long periodMs = 20000L;
    private long initDelayMs = 6000L;
    private ScheduledExecutorService scheduler;
    private final SyncPointContext context = new SyncPointContext();
    private DisposeEventPositionBridge disposeEventPositionBridge;

    public void init() {
        LOGGER.info("Start {} in background, initDelayMs={}, periodMs={}", new Object[]{this.getClass().getSimpleName(), this.initDelayMs, this.periodMs});
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                AsyncFixedRateDisposeEventPosition.this.saveSyncPointByDelegate();
            }
        }, this.initDelayMs, this.periodMs, TimeUnit.MILLISECONDS);
    }

    public void destroy() {
        this.scheduler.shutdown();
        try {
            this.scheduler.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void saveSyncPoint(SyncPoint point) {
        this.context.curr = point;
    }

    @Override
    public SyncPoint loadSyncPoint() {
        if (this.context.prev != null) {
            return this.context.prev;
        }
        return super.loadSyncPoint();
    }

    private void saveSyncPointByDelegate() {
        if (this.context.curr != null) {
            if (this.context.prev == null || !ByteBuffer.wrap(this.context.prev.toBytes()).equals(ByteBuffer.wrap(this.context.curr.toBytes()))) {
                this.delegate.saveSyncPoint(this.context.curr);
            }
            this.context.prev = this.context.curr;
        }
    }

    @Override
    public void registerInstance(String insName) {
        super.registerInstance(insName);
        if (this.disposeEventPositionBridge != null) {
            this.disposeEventPositionBridge.register(insName, this);
        }
    }

    public void setDisposeEventPositionBridge(DisposeEventPositionBridge disposeEventPositionBridge) {
        this.disposeEventPositionBridge = disposeEventPositionBridge;
    }

    public long getInitDelayMs() {
        return this.initDelayMs;
    }

    public void setInitDelayMs(long initDelayMs) {
        this.initDelayMs = initDelayMs;
    }

    public long getPeriodMs() {
        return this.periodMs;
    }

    public void setPeriodMs(long periodMs) {
        this.periodMs = periodMs;
    }

    private class SyncPointContext {
        private SyncPoint prev;
        private SyncPoint curr;

        private SyncPointContext() {
        }
    }
}

