/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.eventposition;

import java.math.BigInteger;
import net.neoremind.fountain.eventposition.GroupIdSyncPoint;
import net.neoremind.fountain.eventposition.SyncPoint;
import org.apache.commons.lang3.StringUtils;

public class BaiduGroupIdSyncPoint
implements GroupIdSyncPoint {
    private BigInteger groupId = BigInteger.valueOf(-1L);

    public BaiduGroupIdSyncPoint() {
    }

    public BaiduGroupIdSyncPoint(BigInteger groupId) {
        this.groupId = groupId;
    }

    @Override
    public byte[] toBytes() {
        return this.groupId.toString().getBytes();
    }

    @Override
    public void parse(byte[] buf) {
        String value = new String(buf);
        value = StringUtils.chomp((String)value);
        this.groupId = new BigInteger(value);
    }

    public BigInteger getGroupId() {
        return this.groupId;
    }

    public String toString() {
        return this.groupId.toString();
    }

    @Override
    public BigInteger offerGroupId() {
        return this.groupId;
    }

    @Override
    public boolean isSame(SyncPoint syncPoint) {
        if (!(syncPoint instanceof BaiduGroupIdSyncPoint)) {
            return false;
        }
        if (syncPoint == this) {
            return true;
        }
        BaiduGroupIdSyncPoint groupPoint = (BaiduGroupIdSyncPoint)syncPoint;
        return this.groupId.equals(groupPoint.getGroupId());
    }
}

