/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.eventposition;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.neoremind.fountain.eventposition.SyncPoint;
import org.apache.commons.lang3.StringUtils;

public class BinlogAndOffsetSyncPoint
implements SyncPoint {
    private static final String MULPT_SEP = ";";
    private List<MysqlSyncPoint> syncPointGroup = new ArrayList<MysqlSyncPoint>();

    public BinlogAndOffsetSyncPoint() {
    }

    public BinlogAndOffsetSyncPoint(List<MysqlSyncPoint> syncPointGroup) {
        this.syncPointGroup = syncPointGroup;
    }

    public MysqlSyncPoint getPointByHostAndPort(String host, String ip, int port) {
        MysqlSyncPoint ret = this.getPointByHostAndPort(host, port);
        if (ret == null) {
            return this.getPointByHostAndPort(ip, port);
        }
        return ret;
    }

    public MysqlSyncPoint getPointByHostAndPort(String host, int port) {
        String mysqlId = host + ":" + port;
        for (MysqlSyncPoint pt : this.syncPointGroup) {
            if (!pt.getMysqlId().equals(mysqlId)) continue;
            return pt;
        }
        return null;
    }

    public void addSyncPoint(String host, int port, String binlogName, BigInteger offset) {
        MysqlSyncPoint myPoint = new MysqlSyncPoint();
        myPoint.setMysqlId(host + ":" + port);
        myPoint.setBinlogName(binlogName);
        myPoint.setOffset(offset);
        this.syncPointGroup.add(myPoint);
    }

    @Override
    public byte[] toBytes() {
        if (this.syncPointGroup == null || this.syncPointGroup.size() == 0) {
            return null;
        }
        return this.convert2String().getBytes();
    }

    public String toString() {
        return this.convert2String();
    }

    private String convert2String() {
        if (this.syncPointGroup == null || this.syncPointGroup.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (MysqlSyncPoint pt : this.syncPointGroup) {
            sb.append(pt.toString());
            sb.append(MULPT_SEP);
        }
        return sb.substring(0, sb.length() - 1);
    }

    @Override
    public void parse(byte[] buf) {
        String[] array;
        String info = new String(buf);
        info = StringUtils.chomp((String)info);
        for (String val : array = info.split(MULPT_SEP)) {
            MysqlSyncPoint pt = new MysqlSyncPoint();
            pt.fromString(val);
            this.syncPointGroup.add(pt);
        }
    }

    public List<MysqlSyncPoint> getSyncPointGroup() {
        return Collections.unmodifiableList(this.syncPointGroup);
    }

    public static class MysqlSyncPoint {
        public static final String INFO_SEP = "#";
        private String mysqlId;
        private String binlogName;
        private BigInteger offset = BigInteger.valueOf(-1L);

        public String getMysqlId() {
            return this.mysqlId;
        }

        public void setMysqlId(String mysqlId) {
            this.mysqlId = mysqlId;
        }

        public String getBinlogName() {
            return this.binlogName;
        }

        public void setBinlogName(String binlogName) {
            this.binlogName = binlogName;
        }

        public BigInteger getOffset() {
            return this.offset;
        }

        public void setOffset(BigInteger offset) {
            this.offset = offset;
        }

        public String toString() {
            return this.mysqlId + INFO_SEP + this.binlogName + INFO_SEP + this.offset;
        }

        public void fromString(String info) {
            String[] array = info.split(INFO_SEP);
            this.mysqlId = array[0];
            this.binlogName = array[1];
            this.offset = new BigInteger(array[2]);
        }
    }
}

