/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.eventposition;

import net.neoremind.fountain.eventposition.AbstractProxyDisposeEventPosition;
import net.neoremind.fountain.eventposition.DisposeEventPosition;
import net.neoremind.fountain.eventposition.DisposeEventPositionBridge;
import net.neoremind.fountain.eventposition.GroupIdSyncPoint;
import net.neoremind.fountain.eventposition.SyncPoint;

public class DelayGroupIdDisposeEventPosition
extends AbstractProxyDisposeEventPosition
implements DisposeEventPosition {
    private GroupIdSyncPoint lastPoint;
    private DisposeEventPositionBridge disposeEventPositionBridge;

    @Override
    public void saveSyncPoint(SyncPoint point) {
        if (!(point instanceof GroupIdSyncPoint)) {
            throw new RuntimeException("EventPosition only supports GroupIdSyncPoint.");
        }
        GroupIdSyncPoint nowPoint = (GroupIdSyncPoint)point;
        if (this.isDifferentPoint(nowPoint)) {
            if (this.lastPoint != null) {
                this.delegate.saveSyncPoint(this.lastPoint);
            }
            this.lastPoint = nowPoint;
        }
    }

    @Override
    public void registerInstance(String insName) {
        super.registerInstance(insName);
        if (this.disposeEventPositionBridge != null) {
            this.disposeEventPositionBridge.register(insName, this);
        }
    }

    private boolean isDifferentPoint(GroupIdSyncPoint point) {
        if (this.lastPoint == null) {
            return true;
        }
        return !this.lastPoint.isSame(point);
    }

    public void setDisposeEventPositionBridge(DisposeEventPositionBridge disposeEventPositionBridge) {
        this.disposeEventPositionBridge = disposeEventPositionBridge;
    }
}

