/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.eventposition;

import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.neoremind.fountain.exception.GtIdInvalidException;
import org.apache.commons.lang3.StringUtils;

public class GtId {
    private static final String SERVER_UUID_REG = "[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}";
    private static final Pattern SERVER_UUID_PATTERN = Pattern.compile("[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}");
    private String serverUUID;
    private byte[] serverUUIDbyte;
    private long intervalStart;
    private long intervalEnd;

    public GtId() {
    }

    public GtId(String serverUUID, long intervalStart, long intervalEnd) {
        this.serverUUID = serverUUID;
        this.serverUUIDbyte = new BigInteger(serverUUID.replace("-", ""), 16).toByteArray();
        this.intervalStart = intervalStart;
        this.intervalEnd = intervalEnd;
    }

    public static GtId buildFromString(String str) throws GtIdInvalidException {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        try {
            String[] serverUUIDAndInterval = StringUtils.split((String)str, (String)":");
            String serverUUID = serverUUIDAndInterval[0];
            Matcher serverUUIDfound = SERVER_UUID_PATTERN.matcher(serverUUID);
            if (!serverUUIDfound.find()) {
                throw new GtIdInvalidException("GtId server UUID:" + serverUUID + " does not match pattern");
            }
            String[] intevals = StringUtils.split((String)serverUUIDAndInterval[1], (String)"-");
            Long intervalStart = Long.parseLong(intevals[0]);
            Long intervalEnd = Long.parseLong(intevals[1]);
            if (intervalStart > intervalEnd) {
                throw new GtIdInvalidException("GtId interval start is greater thant end");
            }
            return new GtId(serverUUID, intervalStart, intervalEnd);
        }
        catch (NumberFormatException e) {
            throw new GtIdInvalidException("GtId intervals is not valid, " + e.getMessage());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new GtIdInvalidException("GtId intervals should have 2 pairs");
        }
    }

    public String toString() {
        return this.serverUUID + ":" + this.intervalStart + "-" + this.intervalEnd;
    }

    public String getServerUUID() {
        return this.serverUUID;
    }

    public void setServerUUID(String serverUUID) {
        this.serverUUID = serverUUID;
    }

    public long getIntervalStart() {
        return this.intervalStart;
    }

    public void setIntervalStart(long intervalStart) {
        this.intervalStart = intervalStart;
    }

    public long getIntervalEnd() {
        return this.intervalEnd;
    }

    public void setIntervalEnd(long intervalEnd) {
        this.intervalEnd = intervalEnd;
    }

    public byte[] getServerUUIDbyte() {
        return this.serverUUIDbyte;
    }

    public void setServerUUIDbyte(byte[] serverUUIDbyte) {
        this.serverUUIDbyte = serverUUIDbyte;
    }
}

