/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.eventposition;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.neoremind.fountain.eventposition.GtId;
import net.neoremind.fountain.exception.GtIdInvalidException;
import net.neoremind.fountain.util.ProtocolHelper;
import org.apache.commons.lang3.StringUtils;

public class GtIdSet {
    private List<GtId> gtIdList = new ArrayList<GtId>(4);

    public static GtIdSet buildFromString(String str) {
        String[] gtIdStrs;
        if (StringUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        GtIdSet gtIdSet = new GtIdSet();
        for (String gtIdStr : gtIdStrs = StringUtils.split((String)str, (String)";")) {
            gtIdSet.getGtIdList().add(GtId.buildFromString(gtIdStr));
        }
        return gtIdSet;
    }

    public String toString() {
        return StringUtils.join(this.gtIdList, (String)";");
    }

    public void addGtId(byte[] sid, Long gtId) throws GtIdInvalidException {
        for (GtId id : this.gtIdList) {
            if (!Arrays.equals(id.getServerUUIDbyte(), sid)) continue;
            if (gtId < id.getIntervalStart()) {
                throw new GtIdInvalidException(String.format("This should never happen. Current gtId %s is less than interval start position %s", gtId, id.getIntervalStart()));
            }
            if (gtId < id.getIntervalEnd()) {
                throw new GtIdInvalidException(String.format("This should never happen. Current gtId %s should greater than interval end position %s", gtId, id.getIntervalEnd()));
            }
            id.setIntervalEnd(gtId);
        }
    }

    public int length() {
        return 8 + 40 * this.gtIdList.size();
    }

    public void encode(ByteArrayOutputStream out) throws IOException {
        ProtocolHelper.writeUnsignedLongByLittleEndian(this.gtIdList.size(), out);
        for (GtId gtId : this.gtIdList) {
            out.write(gtId.getServerUUIDbyte());
            ProtocolHelper.writeUnsignedLongByLittleEndian(1L, out);
            ProtocolHelper.writeUnsignedLongByLittleEndian(gtId.getIntervalStart(), out);
            ProtocolHelper.writeUnsignedLongByLittleEndian(gtId.getIntervalEnd(), out);
        }
    }

    public List<GtId> getGtIdList() {
        return this.gtIdList;
    }

    public void setGtIdList(List<GtId> gtIdList) {
        this.gtIdList = gtIdList;
    }
}

