/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.eventposition;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import net.neoremind.fountain.eventposition.BaiduGroupIdSyncPoint;
import net.neoremind.fountain.eventposition.DisposeEventPosition;
import net.neoremind.fountain.eventposition.RegistableDisposeEventPosition;
import net.neoremind.fountain.eventposition.SyncPoint;
import net.neoremind.fountain.thread.annotaion.UnThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnThreadSafe
public class LocalFileDisposeEventPosition
extends RegistableDisposeEventPosition
implements DisposeEventPosition {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalFileDisposeEventPosition.class);
    private static final int LINE_MAX_SIZE = 1024;
    protected static final String INFO_SEP = ":";
    private String rootPath;

    public LocalFileDisposeEventPosition() {
    }

    public LocalFileDisposeEventPosition(String rootPath) {
        this.rootPath = rootPath;
    }

    @Override
    public synchronized SyncPoint loadSyncPoint() {
        byte[] info = this.readBytesInfo();
        if (info == null) {
            return null;
        }
        SyncPoint point = this.createSyncPoint();
        point.parse(info);
        return point;
    }

    @Override
    public synchronized void saveSyncPoint(SyncPoint point) {
        if (point == null) {
            return;
        }
        ByteBuffer buf = ByteBuffer.wrap(point.toBytes());
        this.writeCore(buf);
        LOGGER.info("Save SyncPoint:{}", (Object)point);
    }

    protected SyncPoint createSyncPoint() {
        return new BaiduGroupIdSyncPoint();
    }

    protected String getFileExt() {
        return null;
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    private String getFilePath() {
        String ext = this.getFileExt();
        if (ext == null) {
            return this.rootPath + "/" + super.getInstanceName();
        }
        return this.rootPath + "/" + super.getInstanceName() + "." + ext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readBytesInfo() {
        String path = this.getFilePath();
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        AbstractInterruptibleChannel fc = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            fc = fis.getChannel();
            ByteBuffer buf = ByteBuffer.allocate(1024);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            int count = ((FileChannel)fc).read(buf);
            if (count <= 0) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] readBytes = new byte[count];
            buf.flip();
            buf.get(readBytes);
            byte[] byArray = readBytes;
            return byArray;
        }
        catch (FileNotFoundException e) {
            this.getLogger().error(null, (Throwable)e);
        }
        catch (IOException e) {
            this.getLogger().error(null, (Throwable)e);
        }
        finally {
            if (fc != null) {
                try {
                    fc.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCore(ByteBuffer buf) {
        this.checkRootPath();
        String path = this.getFilePath();
        File file = new File(path);
        AbstractInterruptibleChannel fc = null;
        try {
            FileOutputStream fis = new FileOutputStream(file);
            fc = fis.getChannel();
            buf.order(ByteOrder.LITTLE_ENDIAN);
            while (buf.remaining() > 0) {
                ((FileChannel)fc).write(buf);
            }
        }
        catch (FileNotFoundException e) {
            this.getLogger().error(null, (Throwable)e);
        }
        catch (IOException e) {
            this.getLogger().error(null, (Throwable)e);
        }
        finally {
            if (fc != null) {
                try {
                    fc.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void checkRootPath() {
        File dir = new File(this.rootPath);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new RuntimeException("SyncPoint file parent path don't exist.");
        }
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public static void main(String[] args) {
        LocalFileDisposeEventPosition dp = new LocalFileDisposeEventPosition();
        dp.setRootPath("/Users/baidu/work/fountain/test");
        dp.registerInstance("test00");
        SyncPoint syncPoint = dp.loadSyncPoint();
        System.out.println(new String(syncPoint.toBytes()));
    }
}

