/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.meta;

import java.util.HashMap;
import java.util.Map;
import net.neoremind.fountain.datasource.MysqlDataSource;
import net.neoremind.fountain.meta.TableMeta;
import net.neoremind.fountain.meta.TableMetaProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedTableMetaProvider
implements TableMetaProvider {
    private static final Logger logger = LoggerFactory.getLogger(CachedTableMetaProvider.class);
    private Map<String, TableMeta> tableNameMetaMap = new HashMap<String, TableMeta>(128);
    private final MysqlDataSource mysqlDataSource;

    public CachedTableMetaProvider(MysqlDataSource mysqlDataSource) {
        this.mysqlDataSource = mysqlDataSource;
    }

    @Override
    public TableMeta getTableMeta(String tableFullName, long tableId) {
        TableMeta tableMeta = this.tableNameMetaMap.get(tableFullName);
        if (tableMeta != null) {
            if (tableMeta.getTableId() == tableId) {
                return tableMeta;
            }
            this.tableNameMetaMap.remove(tableFullName);
        }
        try {
            tableMeta = this.mysqlDataSource.queryTableMeta(tableFullName);
            if (tableMeta != null) {
                tableMeta.setTableId(tableId);
                this.tableNameMetaMap.put(tableFullName, tableMeta);
                return tableMeta;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

