/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.meta;

import net.neoremind.fountain.meta.ColumnTypeEnum;
import net.neoremind.fountain.meta.DatabusColBitmapFlag;
import org.apache.commons.lang3.StringUtils;

public class ColumnMeta {
    private String columnName;
    private String columnType;
    private String generalColumnType;
    private ColumnTypeEnum typeEnum;
    private String charset;
    private String shortCharset;
    private String nullFlag;
    private String keyFlag;
    private String defaultValue;
    private String extra;
    private int metaValue;
    private boolean fromDatabus = false;
    private int databusColumnBitmap;

    public String toString() {
        return "ColumnMeta{columnName='" + this.columnName + '\'' + ", columnType='" + this.columnType + '\'' + ", generalColumnType='" + this.generalColumnType + '\'' + ", typeEnum=" + (Object)((Object)this.typeEnum) + ", charset='" + this.charset + '\'' + ", shortCharset='" + this.shortCharset + '\'' + ", nullFlag='" + this.nullFlag + '\'' + ", keyFlag='" + this.keyFlag + '\'' + ", defaultValue='" + this.defaultValue + '\'' + '}';
    }

    public boolean isUnsigned() {
        if (!this.fromDatabus) {
            return StringUtils.containsIgnoreCase((CharSequence)this.columnType, (CharSequence)"unsigned");
        }
        return (this.databusColumnBitmap & DatabusColBitmapFlag.UNSIGNED_FLAG.getValue()) == DatabusColBitmapFlag.UNSIGNED_FLAG.getValue();
    }

    public boolean isNullable() {
        if (!this.fromDatabus) {
            return StringUtils.equalsIgnoreCase((CharSequence)this.nullFlag, (CharSequence)"YES");
        }
        return (this.databusColumnBitmap & DatabusColBitmapFlag.NOT_NULL_FLAG.getValue()) <= 0;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getColumnType() {
        return this.columnType;
    }

    public void setColumnType(String columnType) {
        this.columnType = columnType;
        this.convert2GeneralColumnType(columnType);
        this.typeEnum = ColumnTypeEnum.getTypeEnumByText(this.generalColumnType);
    }

    private void convert2GeneralColumnType(String text) {
        int pos = text.indexOf("(");
        this.generalColumnType = pos > 0 ? text.substring(0, pos) : text;
        if (StringUtils.isNotEmpty((CharSequence)this.generalColumnType) && this.generalColumnType.contains("unsigned")) {
            this.generalColumnType = this.generalColumnType.replace("unsigned", "").trim();
        }
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
        if (!StringUtils.isEmpty((CharSequence)charset)) {
            String[] array = charset.split("_");
            this.shortCharset = array[0];
        }
    }

    public String getShortCharset() {
        return this.shortCharset;
    }

    public void setShortCharset(String shortCharset) {
        this.shortCharset = shortCharset;
    }

    public String getNullFlag() {
        return this.nullFlag;
    }

    public void setNullFlag(String nullFlag) {
        this.nullFlag = nullFlag;
    }

    public String getKeyFlag() {
        return this.keyFlag;
    }

    public void setKeyFlag(String keyFlag) {
        this.keyFlag = keyFlag;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public ColumnTypeEnum getTypeEnum() {
        return this.typeEnum;
    }

    public void setTypeEnum(ColumnTypeEnum typeEnum) {
        this.typeEnum = typeEnum;
    }

    public int getMetaValue() {
        return this.metaValue;
    }

    public void setMetaValue(int metaValue) {
        this.metaValue = metaValue;
    }

    public boolean isFromDatabus() {
        return this.fromDatabus;
    }

    public void setFromDatabus(boolean fromDatabus) {
        this.fromDatabus = fromDatabus;
    }

    public void setGeneralColumnType(String generalColumnType) {
        this.generalColumnType = generalColumnType;
    }

    public int getDatabusColumnBitmap() {
        return this.databusColumnBitmap;
    }

    public void setDatabusColumnBitmap(int databusColumnBitmap) {
        this.databusColumnBitmap = databusColumnBitmap;
    }

    public String getGeneralColumnType() {
        return this.generalColumnType;
    }
}

