/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.meta;

import java.util.HashMap;
import java.util.Map;

public enum ColumnTypeEnum {
    MYSQL_TYPE_DECIMAL(0, "olddecimal", 2),
    MYSQL_TYPE_TINY(1, "tinyint", 0),
    MYSQL_TYPE_SHORT(2, "smallint", 0),
    MYSQL_TYPE_LONG(3, "int", 0),
    MYSQL_TYPE_FLOAT(4, "float", 1),
    MYSQL_TYPE_DOUBLE(5, "double", 1),
    MYSQL_TYPE_NULL(6, "nullbitmap", 0),
    MYSQL_TYPE_TIMESTAMP(7, "timestamp", 0),
    MYSQL_TYPE_LONGLONG(8, "bigint", 0),
    MYSQL_TYPE_INT24(9, "mediumint", 0),
    MYSQL_TYPE_DATE(10, "olddate", 0),
    MYSQL_TYPE_TIME(11, "time", 0),
    MYSQL_TYPE_DATETIME(12, "datetime", 0),
    MYSQL_TYPE_YEAR(13, "year", 0),
    MYSQL_TYPE_NEWDATE(14, "date", 0),
    MYSQL_TYPE_VARCHAR(15, "varchar", 2),
    MYSQL_TYPE_BIT(16, "bit", 0),
    MYSQL_TYPE_TIMESTAMP2(17, "timestamp", 0),
    MYSQL_TYPE_DATETIME2(18, "datetime", 0),
    MYSQL_TYPE_TIME2(19, "time", 0),
    MYSQL_TYPE_NEWDECIMAL(246, "decimal", 2),
    MYSQL_TYPE_ENUM(247, "enum", 2),
    MYSQL_TYPE_SET(248, "set", 2),
    MYSQL_TYPE_TINY_BLOB(249, "tinyblob", 1),
    MYSQL_TYPE_MEDIUM_BLOB(250, "mediumblob", 1),
    MYSQL_TYPE_LONG_BLOB(251, "longblob", 1),
    MYSQL_TYPE_BLOB(252, "blob", 1),
    MYSQL_TYPE_VAR_STRING(253, "unknown", 2),
    MYSQL_TYPE_STRING(254, "char", 2),
    MYSQL_TYPE_GEOMETRY(255, "geometry", 0);

    private int typeValue;
    private String typeName;
    private int metaLen;
    private static final Map<String, String> TYPE_MAP;

    private ColumnTypeEnum(int value, String name, int mLen) {
        this.typeValue = value;
        this.typeName = name;
        this.metaLen = mLen;
    }

    public static ColumnTypeEnum getTypeEnumByValue(int val) {
        for (ColumnTypeEnum colType : ColumnTypeEnum.values()) {
            if (colType.getTypeValue() != val) continue;
            return colType;
        }
        throw new RuntimeException("invlid column type:" + val);
    }

    public static ColumnTypeEnum getTypeEnumByText(String val) {
        String valueText = TYPE_MAP.get(val);
        if (valueText == null) {
            valueText = val;
        }
        for (ColumnTypeEnum colType : ColumnTypeEnum.values()) {
            if (!colType.getTypeName().equalsIgnoreCase(valueText)) continue;
            return colType;
        }
        throw new RuntimeException("invlid column type:" + val);
    }

    public boolean isStringType(ColumnTypeEnum typeEnum) {
        return typeEnum == MYSQL_TYPE_VARCHAR || typeEnum == MYSQL_TYPE_VAR_STRING || typeEnum == MYSQL_TYPE_STRING;
    }

    public int getTypeValue() {
        return this.typeValue;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getMetaLen() {
        return this.metaLen;
    }

    static {
        TYPE_MAP = new HashMap<String, String>();
        TYPE_MAP.put("tinytext", "blob");
        TYPE_MAP.put("mediumtext", "blob");
        TYPE_MAP.put("text", "blob");
        TYPE_MAP.put("longtext", "blob");
        TYPE_MAP.put("binary", "char");
        TYPE_MAP.put("varbinary", "varchar");
    }
}

