/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.packet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import net.neoremind.fountain.packet.MysqlPacket;
import net.neoremind.fountain.util.Encrypter;
import net.neoremind.fountain.util.ProtocolHelper;

public class ClientAuthPacket
extends MysqlPacket {
    private static final long serialVersionUID = 8370460395899023539L;
    private String username;
    private String password;
    private String databaseName;
    private byte charsetNumber;
    private byte[] scrumbleBuff;

    public byte[] toBytes() throws IOException, NoSuchAlgorithmException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ProtocolHelper.writeUnsignedIntByLittleEndian(41477, out);
        ProtocolHelper.writeUnsignedIntByLittleEndian(0x1000000, out);
        out.write(this.charsetNumber);
        out.write(new byte[23]);
        ProtocolHelper.writeNullTerminatedString(this.username, out);
        if (this.password == null || this.password.length() == 0) {
            out.write(0);
        } else {
            byte[] encryptPassword = Encrypter.encryptBySHA(this.password.getBytes(), this.scrumbleBuff);
            ProtocolHelper.writeLengthCodedBinary(encryptPassword, out);
        }
        if (this.databaseName != null) {
            ProtocolHelper.writeNullTerminatedString(this.databaseName, out);
        }
        return out.toByteArray();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public byte getCharsetNumber() {
        return this.charsetNumber;
    }

    public void setCharsetNumber(byte charsetNumber) {
        this.charsetNumber = charsetNumber;
    }

    public byte[] getScrumbleBuff() {
        return this.scrumbleBuff;
    }

    public void setScrumbleBuff(byte[] scrumbleBuff) {
        this.scrumbleBuff = scrumbleBuff;
    }

    @Override
    public void fromBytes(byte[] data) {
    }
}

