/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.packet;

import net.neoremind.fountain.exception.ParamErrorException;
import net.neoremind.fountain.packet.MysqlPacket;
import net.neoremind.fountain.packet.Position;
import net.neoremind.fountain.util.ProtocolHelper;

public class EOFPacket
extends MysqlPacket {
    private static final long serialVersionUID = -4501952768725151045L;
    public static final byte EOF_FLAG = -2;
    private byte eofFlag;
    private int warningCount;
    private byte[] statusFlags;

    public static boolean isEOFPacket(byte[] data) {
        if (data == null || data.length == 0) {
            throw new ParamErrorException("data is not valid");
        }
        return data[0] == -2;
    }

    @Override
    public void fromBytes(byte[] data) {
        if (data == null || data.length == 0) {
            throw new ParamErrorException("data is not valid");
        }
        Position position = new Position();
        this.eofFlag = data[position.getPosition()];
        position.increase();
        if (data.length == 1) {
            return;
        }
        this.warningCount = (int)ProtocolHelper.getUnsignedIntByLittleEndian(data, position, 2);
        this.statusFlags = ProtocolHelper.getFixedBytes(data, position, 2);
    }

    public byte getEofFlag() {
        return this.eofFlag;
    }

    public void setEofFlag(byte eofFlag) {
        this.eofFlag = eofFlag;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public void setWarningCount(int warningCount) {
        this.warningCount = warningCount;
    }

    public byte[] getStatusFlags() {
        return this.statusFlags;
    }

    public void setStatusFlags(byte[] statusFlags) {
        this.statusFlags = statusFlags;
    }
}

