/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.packet;

import java.util.Arrays;
import net.neoremind.fountain.exception.ParamErrorException;
import net.neoremind.fountain.packet.MysqlPacket;
import net.neoremind.fountain.packet.Position;
import net.neoremind.fountain.util.ProtocolHelper;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ErrorPacket
extends MysqlPacket {
    private static final long serialVersionUID = -8788492242358140571L;
    public static final byte ERROR_FLAG = -1;
    private byte errorFlag;
    private int errorCode;
    private byte sqlstateMarker;
    private byte[] sqlstate;
    private String message;

    public static boolean isErrorPacket(byte[] data) {
        if (data == null || data.length == 0) {
            throw new ParamErrorException("data is not valid");
        }
        return data[0] == -1;
    }

    @Override
    public void fromBytes(byte[] data) {
        if (data == null || data.length == 0) {
            throw new ParamErrorException("data is not valid");
        }
        Position position = new Position();
        this.errorFlag = data[position.getPosition()];
        position.increase();
        this.errorCode = (int)ProtocolHelper.getUnsignedIntByLittleEndian(data, position, 2);
        this.sqlstateMarker = data[position.getPosition()];
        position.increase();
        this.sqlstate = ProtocolHelper.getFixedBytes(data, position, 5);
        this.message = new String(ProtocolHelper.getFixedBytes(data, position, data.length - position.getPosition()));
    }

    public byte getErrorFlag() {
        return this.errorFlag;
    }

    public void setErrorFlag(byte errorFlag) {
        this.errorFlag = errorFlag;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public byte getSqlstateMarker() {
        return this.sqlstateMarker;
    }

    public void setSqlstateMarker(byte sqlstateMarker) {
        this.sqlstateMarker = sqlstateMarker;
    }

    public byte[] getSqlstate() {
        return this.sqlstate;
    }

    public void setSqlstate(byte[] sqlstate) {
        this.sqlstate = sqlstate;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("errorCode", this.errorCode).append("errorFlag", this.errorFlag).append("sqlstateMarker", this.sqlstateMarker).append("sqlstate", (Object)Arrays.deepToString(ArrayUtils.toObject((byte[])this.sqlstate))).append("message", (Object)this.message).toString();
    }
}

