/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.packet;

import net.neoremind.fountain.packet.MysqlPacket;
import net.neoremind.fountain.packet.Position;
import net.neoremind.fountain.util.ProtocolHelper;

public class FieldDescriptionPacket
extends MysqlPacket {
    private static final long serialVersionUID = 1585203012794038075L;
    private String catalog;
    private String dbName;
    private String tableAlias;
    private String tableName;
    private String columnAlias;
    private String columnName;
    private int character;
    private long length;
    private byte type;
    private int flags;
    private byte decimal;
    private byte[] defaultExtra;

    @Override
    public void fromBytes(byte[] data) {
        Position position = new Position();
        int dataLength = (int)ProtocolHelper.getLengthCodedLength(data, position);
        this.catalog = new String(ProtocolHelper.getFixedBytes(data, position, dataLength));
        dataLength = (int)ProtocolHelper.getLengthCodedLength(data, position);
        this.dbName = new String(ProtocolHelper.getFixedBytes(data, position, dataLength));
        dataLength = (int)ProtocolHelper.getLengthCodedLength(data, position);
        this.tableAlias = new String(ProtocolHelper.getFixedBytes(data, position, dataLength));
        dataLength = (int)ProtocolHelper.getLengthCodedLength(data, position);
        this.tableName = new String(ProtocolHelper.getFixedBytes(data, position, dataLength));
        dataLength = (int)ProtocolHelper.getLengthCodedLength(data, position);
        this.columnAlias = new String(ProtocolHelper.getFixedBytes(data, position, dataLength));
        dataLength = (int)ProtocolHelper.getLengthCodedLength(data, position);
        this.columnName = new String(ProtocolHelper.getFixedBytes(data, position, dataLength));
        position.increase();
        this.character = (int)ProtocolHelper.getUnsignedIntByLittleEndian(data, position, 2);
        this.length = ProtocolHelper.getUnsignedIntByLittleEndian(data, position, 4);
        this.type = (byte)ProtocolHelper.getUnsignedIntByLittleEndian(data, position, 1);
        this.flags = (int)ProtocolHelper.getUnsignedIntByLittleEndian(data, position, 2);
        this.decimal = (byte)ProtocolHelper.getUnsignedIntByLittleEndian(data, position, 1);
        position.increase(2);
        if (position.getPosition() < data.length) {
            this.defaultExtra = ProtocolHelper.getFixedBytes(data, position, data.length - position.getPosition());
        }
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public void setTableAlias(String tableAlias) {
        this.tableAlias = tableAlias;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getColumnAlias() {
        return this.columnAlias;
    }

    public void setColumnAlias(String columnAlias) {
        this.columnAlias = columnAlias;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public int getCharacter() {
        return this.character;
    }

    public void setCharacter(int character) {
        this.character = character;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public byte getDecimal() {
        return this.decimal;
    }

    public void setDecimal(byte decimal) {
        this.decimal = decimal;
    }

    public byte[] getDefaultExtra() {
        return this.defaultExtra;
    }

    public void setDefaultExtra(byte[] defaultExtra) {
        this.defaultExtra = defaultExtra;
    }
}

