/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.packet;

import net.neoremind.fountain.packet.MysqlPacket;
import net.neoremind.fountain.packet.Position;
import net.neoremind.fountain.util.ProtocolHelper;

public class HandshakePacket
extends MysqlPacket {
    private static final long serialVersionUID = 6362408117953514233L;
    private byte protocolVersion;
    private String version;
    private int threadId;
    private byte[] seed;
    private int serverCapabilities;
    private byte serverCharsetNumber;
    private int serverStatus;
    private byte[] restOfScrambleBuff;

    public byte[] getScrambleBuff() {
        byte[] dest = new byte[this.seed.length + this.restOfScrambleBuff.length];
        System.arraycopy(this.seed, 0, dest, 0, this.seed.length);
        System.arraycopy(this.restOfScrambleBuff, 0, dest, this.seed.length, this.restOfScrambleBuff.length);
        return dest;
    }

    @Override
    public void fromBytes(byte[] data) {
        Position position = new Position();
        this.protocolVersion = data[position.getPosition()];
        position.increase();
        this.version = ProtocolHelper.getNullTerminatedString(data, position);
        this.threadId = (int)ProtocolHelper.getUnsignedIntByLittleEndian(data, position, 4);
        this.seed = ProtocolHelper.getFixedBytes(data, position, 8);
        position.increase();
        this.serverCapabilities = (int)ProtocolHelper.getUnsignedIntByLittleEndian(data, position, 2);
        this.serverCharsetNumber = (byte)ProtocolHelper.getUnsignedIntByLittleEndian(data, position, 1);
        this.serverStatus = (int)ProtocolHelper.getUnsignedIntByLittleEndian(data, position, 2);
        position.increase(2);
        position.increase();
        position.increase(10);
        this.restOfScrambleBuff = ProtocolHelper.getFixedBytes(data, position, 12);
        position.increase();
    }

    public byte getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(byte protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public int getThreadId() {
        return this.threadId;
    }

    public void setThreadId(int threadId) {
        this.threadId = threadId;
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public void setSeed(byte[] seed) {
        this.seed = seed;
    }

    public int getServerCapabilities() {
        return this.serverCapabilities;
    }

    public void setServerCapabilities(int serverCapabilities) {
        this.serverCapabilities = serverCapabilities;
    }

    public byte getServerCharsetNumber() {
        return this.serverCharsetNumber;
    }

    public void setServerCharsetNumber(byte serverCharsetNumber) {
        this.serverCharsetNumber = serverCharsetNumber;
    }

    public int getServerStatus() {
        return this.serverStatus;
    }

    public void setServerStatus(int serverStatus) {
        this.serverStatus = serverStatus;
    }

    public byte[] getRestOfScrambleBuff() {
        return this.restOfScrambleBuff;
    }

    public void setRestOfScrambleBuff(byte[] restOfScrambleBuff) {
        this.restOfScrambleBuff = restOfScrambleBuff;
    }
}

