/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.packet;

import net.neoremind.fountain.exception.ParamErrorException;
import net.neoremind.fountain.packet.MysqlPacket;
import net.neoremind.fountain.packet.Position;
import net.neoremind.fountain.util.ProtocolHelper;

public class OKPacket
extends MysqlPacket {
    private static final long serialVersionUID = 939916149041573794L;
    public byte okflag;
    public byte[] affectRows;
    public byte[] insertId;
    public int serverStatus;
    public int warningStatus;
    public String message;

    @Override
    public void fromBytes(byte[] data) {
        if (data == null || data.length == 0) {
            throw new ParamErrorException("data is not valid");
        }
        Position position = new Position();
        this.okflag = data[position.getPosition()];
        position.increase();
        this.affectRows = ProtocolHelper.getLengthCodedBytes(data, position);
        this.insertId = ProtocolHelper.getLengthCodedBytes(data, position);
        this.serverStatus = (int)ProtocolHelper.getUnsignedIntByLittleEndian(data, position, 2);
        this.warningStatus = (int)ProtocolHelper.getUnsignedIntByLittleEndian(data, position, 2);
        this.message = new String(ProtocolHelper.getFixedBytes(data, position, data.length - position.getPosition()));
    }

    public byte getOkflag() {
        return this.okflag;
    }

    public void setOkflag(byte okflag) {
        this.okflag = okflag;
    }

    public byte[] getAffectRows() {
        return this.affectRows;
    }

    public void setAffectRows(byte[] affectRows) {
        this.affectRows = affectRows;
    }

    public byte[] getInsertId() {
        return this.insertId;
    }

    public void setInsertId(byte[] insertId) {
        this.insertId = insertId;
    }

    public int getServerStatus() {
        return this.serverStatus;
    }

    public void setServerStatus(int serverStatus) {
        this.serverStatus = serverStatus;
    }

    public int getWarningStatus() {
        return this.warningStatus;
    }

    public void setWarningStatus(int warningStatus) {
        this.warningStatus = warningStatus;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

