/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.rowbaselog.event;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import net.neoremind.fountain.event.EventHeader;
import net.neoremind.fountain.packet.Position;
import net.neoremind.fountain.util.MysqlValueHelper;
import net.neoremind.fountain.util.ProtocolHelper;
import net.neoremind.fountain.util.UnsignedNumberHelper;
import org.apache.commons.lang3.ArrayUtils;

public class BinlogEventHeader
implements EventHeader {
    private long timestamp;
    private byte typeCode;
    private int serverId;
    private int eventLength;
    private long nextPosition;
    private int flags;
    private byte[] extraHeaders;
    private BigInteger groupId = new BigInteger("-1");
    private final int extraHeadersLength;

    public BinlogEventHeader(int extraHeadersLength) {
        this.extraHeadersLength = extraHeadersLength;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public byte getTypeCode() {
        return this.typeCode;
    }

    public void setTypeCode(byte typeCode) {
        this.typeCode = typeCode;
    }

    public int getServerId() {
        return this.serverId;
    }

    public void setServerId(int serverId) {
        this.serverId = serverId;
    }

    public int getEventLength() {
        return this.eventLength;
    }

    public void setEventLength(int eventLength) {
        this.eventLength = eventLength;
    }

    public long getNextPosition() {
        return this.nextPosition;
    }

    public void setNextPosition(long nextPosition) {
        this.nextPosition = nextPosition;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public byte[] getExtraHeaders() {
        return this.extraHeaders;
    }

    public void setExtraHeaders(byte[] extraHeaders) {
        this.extraHeaders = extraHeaders;
        if (ArrayUtils.isEmpty((byte[])extraHeaders) || extraHeaders.length != 8) {
            return;
        }
        this.groupId = ProtocolHelper.getUnsignedLongByLittleEndian(extraHeaders, new Position(0), 8);
    }

    @Override
    public BigInteger getGroupId() {
        return this.groupId;
    }

    @Override
    public void parseHeader(ByteBuffer buff) {
        this.setTimestamp(UnsignedNumberHelper.convertLittleEndianUnsignedInt(buff, 4));
        this.setTypeCode((byte)UnsignedNumberHelper.convertLittleEndianUnsignedInt(buff, 1));
        this.setServerId((int)UnsignedNumberHelper.convertLittleEndianUnsignedInt(buff, 4));
        this.setEventLength((int)UnsignedNumberHelper.convertLittleEndianUnsignedInt(buff, 4));
        this.setNextPosition(UnsignedNumberHelper.convertLittleEndianUnsignedInt(buff, 4));
        this.setFlags((int)UnsignedNumberHelper.convertLittleEndianUnsignedInt(buff, 2));
        if (this.extraHeadersLength > 0 && 4 != this.getTypeCode() && 15 != this.getTypeCode() && 1 != this.getTypeCode()) {
            this.setExtraHeaders(MysqlValueHelper.getFixedBytes(buff, this.extraHeadersLength));
        }
    }
}

