/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.rowbaselog.event;

import java.nio.ByteBuffer;
import java.util.Arrays;
import net.neoremind.fountain.event.BaseLogEvent;
import net.neoremind.fountain.rowbaselog.event.BinlogEventHeader;
import net.neoremind.fountain.rowbaselog.event.FormatInfo;
import net.neoremind.fountain.rowbaselog.event.FormatInfoCallback;
import net.neoremind.fountain.util.MysqlValueHelper;
import net.neoremind.fountain.util.UnsignedNumberHelper;

public class FormatDescriptionEvent
extends BaseLogEvent {
    private static final long serialVersionUID = -2282983822156668425L;
    public static final int NORMAL_HEADER_LENGTH = 19;
    public int binlogVersion;
    public String serverVersion;
    public int binlogCreateTime;
    public byte eventHeaderLength;
    public byte[] eventDataFixedPartLength;
    private final FormatInfoCallback callback;
    private int extraHeaderLen;

    public FormatDescriptionEvent(BinlogEventHeader eventHeader, FormatInfoCallback callback) {
        super(eventHeader);
        this.callback = callback;
    }

    @Override
    public BaseLogEvent parseData(ByteBuffer buf) {
        this.binlogVersion = (int)UnsignedNumberHelper.convertLittleEndianUnsignedInt(buf, 2);
        this.serverVersion = UnsignedNumberHelper.convertByteArray2String(MysqlValueHelper.getFixedBytes(buf, 50));
        this.binlogCreateTime = (int)UnsignedNumberHelper.convertLittleEndianUnsignedInt(buf, 4);
        this.eventHeaderLength = MysqlValueHelper.getFixedBytes(buf, 1)[0];
        this.eventDataFixedPartLength = new byte[buf.remaining()];
        buf.get(this.eventDataFixedPartLength);
        this.extraHeaderLen = this.eventHeaderLength - 19;
        if (this.callback != null) {
            this.callback.accept(new FormatInfo(){

                @Override
                public int getExtraHeadersLength() {
                    return FormatDescriptionEvent.this.extraHeaderLen;
                }

                @Override
                public int getPostHeaderLen(int eventType) {
                    return FormatDescriptionEvent.this.eventDataFixedPartLength[eventType - 1];
                }
            });
        }
        return this;
    }

    public String toString() {
        return "FormatDescriptionEvent{serverVersion='" + this.serverVersion + '\'' + ", binlogVersion=" + this.binlogVersion + ", binlogCreateTime=" + this.binlogCreateTime + ", eventHeaderLength=" + this.eventHeaderLength + ", eventDataFixedPartLength=" + Arrays.toString(this.eventDataFixedPartLength) + ", extraHeaderLen=" + this.extraHeaderLen + '}';
    }
}

