/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.rowbaselog.event;

import java.nio.ByteBuffer;
import net.neoremind.fountain.event.BaseLogEvent;
import net.neoremind.fountain.rowbaselog.event.BinlogEventHeader;
import net.neoremind.fountain.util.MysqlValueHelper;
import net.neoremind.fountain.util.UnsignedNumberHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtidEvent
extends BaseLogEvent {
    private static final Logger logger = LoggerFactory.getLogger(GtidEvent.class);
    private static final long serialVersionUID = 3904701082535625594L;
    private byte[] sid;
    private long gtId;

    public GtidEvent(BinlogEventHeader eventHeader) {
        super(eventHeader);
    }

    @Override
    public BaseLogEvent parseData(ByteBuffer buf) {
        byte[] flag = new byte[1];
        buf.get(flag);
        this.sid = MysqlValueHelper.getFixedBytes(buf, 16);
        this.gtId = UnsignedNumberHelper.convertLittleEndianLong(buf, 8);
        return this;
    }

    public byte[] getSid() {
        return this.sid;
    }

    public void setSid(byte[] sid) {
        this.sid = sid;
    }

    public long getGtId() {
        return this.gtId;
    }

    public void setGtId(long gtId) {
        this.gtId = gtId;
    }
}

