/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.rowbaselog.event;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import net.neoremind.fountain.event.BaseLogEvent;
import net.neoremind.fountain.rowbaselog.event.BinlogEventHeader;
import net.neoremind.fountain.util.MysqlValueHelper;
import net.neoremind.fountain.util.UnsignedNumberHelper;

public class QueryLogEvent
extends BaseLogEvent {
    private static final long serialVersionUID = -1567353892593172493L;
    public int threadId;
    public long executeTime;
    public byte dbNameLength;
    public int errorCode;
    public int statusVariableLength;
    public Map<String, Object> variableMap = new HashMap<String, Object>();
    public String dbName;
    public String query;

    public QueryLogEvent(BinlogEventHeader eventHeader) {
        super(eventHeader);
    }

    @Override
    public BaseLogEvent parseData(ByteBuffer buf) {
        this.threadId = (int)UnsignedNumberHelper.convertLittleEndianUnsignedInt(buf, 4);
        this.executeTime = UnsignedNumberHelper.convertLittleEndianUnsignedInt(buf, 4);
        this.dbNameLength = (byte)UnsignedNumberHelper.convertLittleEndianUnsignedInt(buf, 1);
        this.errorCode = (int)UnsignedNumberHelper.convertLittleEndianUnsignedInt(buf, 2);
        this.statusVariableLength = (int)UnsignedNumberHelper.convertLittleEndianUnsignedInt(buf, 2);
        this.parseStatusVar(buf);
        this.dbName = UnsignedNumberHelper.convertByteArray2String(MysqlValueHelper.getNullTerminatedByte(buf));
        this.query = UnsignedNumberHelper.convertByteArray2String(MysqlValueHelper.getFixedBytes(buf, buf.remaining()));
        return this;
    }

    private void parseStatusVar(ByteBuffer buf) {
        if (this.statusVariableLength > 0) {
            int variableEndPos = buf.position() + this.statusVariableLength;
            while (buf.position() < variableEndPos) {
                byte variableFlag = (byte)UnsignedNumberHelper.convertLittleEndianUnsignedInt(buf, 1);
                long value = -1L;
                switch (variableFlag) {
                    case 0: {
                        value = UnsignedNumberHelper.convertLittleEndianUnsignedInt(buf, 4);
                        this.variableMap.put("flags2", value);
                        break;
                    }
                    case 1: {
                        value = UnsignedNumberHelper.convertLittleEndianLong(buf, 8);
                        this.variableMap.put("sql_mode", value);
                        break;
                    }
                    case 2: {
                        buf.position(buf.position() + 1);
                        String catalog = UnsignedNumberHelper.convertByteArray2String(MysqlValueHelper.getNullTerminatedByte(buf));
                        this.variableMap.put("catalog", catalog);
                        break;
                    }
                    case 3: {
                        value = UnsignedNumberHelper.convertLittleEndianUnsignedInt(buf, 2);
                        this.variableMap.put("auto_increment_increment", value);
                        value = UnsignedNumberHelper.convertLittleEndianUnsignedInt(buf, 2);
                        this.variableMap.put("auto_increment_offset ", value);
                        break;
                    }
                    case 4: {
                        value = UnsignedNumberHelper.convertLittleEndianUnsignedInt(buf, 2);
                        this.variableMap.put("character_set_client", value);
                        value = UnsignedNumberHelper.convertLittleEndianUnsignedInt(buf, 2);
                        this.variableMap.put("collation_connection", value);
                        UnsignedNumberHelper.convertLittleEndianUnsignedInt(buf, 2);
                        this.variableMap.put("collation_server ", value);
                        break;
                    }
                    case 5: {
                        int length = (int)UnsignedNumberHelper.convertLittleEndianUnsignedInt(buf, 1);
                        String time_zone = UnsignedNumberHelper.convertByteArray2String(MysqlValueHelper.getFixedBytes(buf, length));
                        this.variableMap.put("time_zone", time_zone);
                        break;
                    }
                    case 6: {
                        int length = (int)UnsignedNumberHelper.convertLittleEndianUnsignedInt(buf, 1);
                        String catalog = UnsignedNumberHelper.convertByteArray2String(MysqlValueHelper.getFixedBytes(buf, length));
                        this.variableMap.put("catalog", catalog);
                        break;
                    }
                    case 7: {
                        value = UnsignedNumberHelper.convertLittleEndianUnsignedInt(buf, 2);
                        this.variableMap.put("lc_time_names ", value);
                        break;
                    }
                    case 8: {
                        value = UnsignedNumberHelper.convertLittleEndianUnsignedInt(buf, 2);
                        this.variableMap.put("collation_database ", value);
                        break;
                    }
                    case 9: {
                        value = UnsignedNumberHelper.convertLittleEndianLong(buf, 8);
                        this.variableMap.put("table_map_for_update ", value);
                    }
                }
            }
        }
    }
}

