/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.rowbaselog.event;

import java.nio.ByteBuffer;
import net.neoremind.fountain.event.BaseLogEvent;
import net.neoremind.fountain.rowbaselog.event.BinlogEventHeader;
import net.neoremind.fountain.support.ThreadHolder;
import net.neoremind.fountain.util.MysqlValueHelper;
import net.neoremind.fountain.util.UnsignedNumberHelper;

public class RotateEvent
extends BaseLogEvent {
    private static final long serialVersionUID = -3183442443627836016L;
    public long nextLogEventPos;
    public String nextLogFileName;

    public RotateEvent(BinlogEventHeader eventHeader) {
        super(eventHeader);
    }

    @Override
    public BaseLogEvent parseData(ByteBuffer buf) {
        byte[] nextLogFileNameBytes;
        this.nextLogEventPos = UnsignedNumberHelper.convertLittleEndianLong(buf, 8);
        byte[] actualLogFileName = nextLogFileNameBytes = MysqlValueHelper.getFixedBytes(buf, buf.remaining());
        if (ThreadHolder.getTrxContext() != null && ThreadHolder.getTrxContext().isChecksumSupport()) {
            actualLogFileName = new byte[nextLogFileNameBytes.length - 4];
            System.arraycopy(nextLogFileNameBytes, 0, actualLogFileName, 0, actualLogFileName.length);
        }
        this.nextLogFileName = UnsignedNumberHelper.convertByteArray2String(actualLogFileName);
        return this;
    }
}

