/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.rowbaselog.event;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import net.neoremind.fountain.event.BaseLogEvent;
import net.neoremind.fountain.event.ColumnDataParser;
import net.neoremind.fountain.event.ColumnDataParserFactory;
import net.neoremind.fountain.event.EventHeader;
import net.neoremind.fountain.event.RowEvent;
import net.neoremind.fountain.event.data.ColumnData;
import net.neoremind.fountain.event.data.RowData;
import net.neoremind.fountain.meta.ColumnMeta;
import net.neoremind.fountain.meta.TableMeta;
import net.neoremind.fountain.rowbaselog.event.EventConstant;
import net.neoremind.fountain.rowbaselog.event.TableInfoCallback;
import net.neoremind.fountain.rowbaselog.event.TableMapEvent;
import net.neoremind.fountain.rowbaselog.event.UnkownBinlogEvent;
import net.neoremind.fountain.util.MysqlValueHelper;
import net.neoremind.fountain.util.UnsignedNumberHelper;

public class RowsLogEvent
extends BaseLogEvent
implements RowEvent {
    private static final long serialVersionUID = 1434103941591941107L;
    private int dataLen;
    public long tableId;
    public int reserved;
    public int columnsLength;
    public BitSet columnUsedBitSet = new BitSet();
    public BitSet columnUpdateUsedBitSet = new BitSet();
    public List<RowData> rowDataList = new ArrayList<RowData>();
    private final int headerLen;
    private final byte eventType;
    private final TableInfoCallback tableInfoCallback;
    private final ColumnDataParserFactory columnParserFactory;
    private TableMeta tableMeta;

    public TableMeta getTableMeta() {
        return this.tableMeta;
    }

    public RowsLogEvent(EventHeader eventHeader, int headerLen, byte eventType, TableInfoCallback tableInfoCallback, ColumnDataParserFactory columnParserFactory) {
        super(eventHeader);
        this.headerLen = headerLen;
        this.eventType = eventType;
        this.tableInfoCallback = tableInfoCallback;
        this.columnParserFactory = columnParserFactory;
    }

    public int getDataLen() {
        return this.dataLen;
    }

    @Override
    public BaseLogEvent parseData(ByteBuffer buf) {
        this.parseHeader(buf);
        TableMapEvent tableMapEvent = this.tableInfoCallback.getTableMapEvent(this.tableId);
        if (tableMapEvent == null) {
            return new UnkownBinlogEvent(super.getEventHeader());
        }
        this.dataLen = buf.remaining();
        this.parseBody(buf);
        this.parseAllRows(buf, tableMapEvent);
        return this;
    }

    @Override
    public boolean isInsert() {
        return EventConstant.isInsert(this.eventType);
    }

    @Override
    public boolean isUpdate() {
        return EventConstant.isUpdate(this.eventType);
    }

    @Override
    public boolean isDelete() {
        return EventConstant.isDelete(this.eventType);
    }

    protected void parseHeader(ByteBuffer buf) {
        this.tableId = this.headerLen == 6 ? UnsignedNumberHelper.convertLittleEndianUnsignedInt(buf, 4) : UnsignedNumberHelper.convertLittleEndianLong(buf, 6);
        this.reserved = (int)UnsignedNumberHelper.convertLittleEndianUnsignedInt(buf, 2);
    }

    protected void parseBody(ByteBuffer buf) {
        this.columnsLength = (int)MysqlValueHelper.convertLengthCodedLength(buf);
        this.fillBitmap(this.columnUsedBitSet, buf);
    }

    protected void fillBitmap(BitSet bs, ByteBuffer buf) {
        int count = (this.columnsLength + 7) / 8;
        int index = 0;
        for (int i = 0; i < count; ++i) {
            byte val = buf.get();
            for (int j = 0; j < 8 && index < this.columnsLength; ++j, ++index) {
                if ((val & EventConstant.bitArray[j]) != EventConstant.bitArray[j]) continue;
                bs.set(index);
            }
        }
    }

    private void parseAllRows(ByteBuffer buf, TableMapEvent tableMapEvent) {
        this.tableMeta = this.tableInfoCallback.getTableMeta(tableMapEvent.getFullTableName(), tableMapEvent.tableId, tableMapEvent.columnInfoArray);
        while (buf.remaining() > 4) {
            this.rowDataList.add(this.parseSingleRow(buf, tableMapEvent));
        }
        if (buf.remaining() != 0 && buf.remaining() != 4) {
            throw new RuntimeException("When reaching here, MySQL binlog checksum CRC32 is enabled and 4 bytes after rows log event which is  the checksum are expected, but the bytes left are not 4");
        }
    }

    protected RowData parseSingleRow(ByteBuffer buf, TableMapEvent tableMapEvent) {
        RowData rd = new RowData();
        List<ColumnData> columnList = this.parseColumnsOfRow(buf, tableMapEvent);
        if (this.isInsert()) {
            rd.setAfterColumnList(columnList);
        } else {
            rd.setBeforeColumnList(columnList);
        }
        return rd;
    }

    protected final List<ColumnData> parseColumnsOfRow(ByteBuffer buf, TableMapEvent tableMapEvent) {
        BitSet rowNullBitSet = new BitSet(this.columnsLength);
        this.fillBitmap(rowNullBitSet, buf);
        int columnCount = tableMapEvent.columnsLength;
        LinkedList<ColumnData> columnList = new LinkedList<ColumnData>();
        for (int i = 0; i < columnCount; ++i) {
            ColumnData colData = new ColumnData();
            if (rowNullBitSet.get(i)) {
                colData.setValue(null);
                colData.setNull(true);
            } else {
                ColumnMeta colMeta = this.tableMeta.getColumnMetaList().get(i);
                colMeta.setMetaValue(tableMapEvent.columnInfoArray[i].meta);
                ColumnDataParser columnParser = this.columnParserFactory.factory(tableMapEvent.columnInfoArray[i].type);
                columnParser.parse(buf, colData, colMeta);
                colData.setNull(false);
            }
            columnList.add(colData);
        }
        return columnList;
    }
}

