/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.rowbaselog.event;

import java.nio.ByteBuffer;
import net.neoremind.fountain.event.ColumnDataParserFactory;
import net.neoremind.fountain.event.EventHeader;
import net.neoremind.fountain.rowbaselog.event.RowsLogEventV1;
import net.neoremind.fountain.rowbaselog.event.TableInfoCallback;
import net.neoremind.fountain.util.MysqlValueHelper;
import net.neoremind.fountain.util.UnsignedNumberHelper;

public class RowsLogEventV2
extends RowsLogEventV1 {
    private static final long serialVersionUID = 1L;
    private int extraDataLen;
    private byte[] extraData;

    public RowsLogEventV2(EventHeader eventHeader, int headerLen, byte eventType, TableInfoCallback tableInfoCallback, ColumnDataParserFactory columnParserFactory) {
        super(eventHeader, headerLen, eventType, tableInfoCallback, columnParserFactory);
    }

    public int getExtraDataLen() {
        return this.extraDataLen;
    }

    public byte[] getExtraData() {
        return this.extraData;
    }

    @Override
    protected void parseHeader(ByteBuffer buf) {
        super.parseHeader(buf);
        this.extraDataLen = (int)UnsignedNumberHelper.convertLittleEndianUnsignedInt(buf, 2);
        if (this.extraDataLen > 2) {
            this.extraData = MysqlValueHelper.getFixedBytes(buf, this.extraDataLen - 2);
        }
    }
}

