/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.fountain.rowbaselog.event;

import java.nio.ByteBuffer;
import java.util.BitSet;
import net.neoremind.fountain.event.BaseLogEvent;
import net.neoremind.fountain.meta.ColumnTypeEnum;
import net.neoremind.fountain.rowbaselog.event.BinlogEventHeader;
import net.neoremind.fountain.rowbaselog.event.EventConstant;
import net.neoremind.fountain.rowbaselog.event.TableEventCallback;
import net.neoremind.fountain.util.MysqlValueHelper;
import net.neoremind.fountain.util.UnsignedNumberHelper;

public class TableMapEvent
extends BaseLogEvent {
    private static final long serialVersionUID = -1326376560309798269L;
    public long tableId;
    public byte[] reserved;
    public byte dbNameLength;
    public String dbName;
    public byte tableNameLength;
    public String tableName;
    public int columnsLength;
    public ColumnInfo[] columnInfoArray;
    public BitSet columnNullMap = new BitSet();
    private final TableEventCallback callback;

    public TableMapEvent(BinlogEventHeader eventHeader, TableEventCallback callback) {
        super(eventHeader);
        this.callback = callback;
    }

    public String getFullTableName() {
        return this.dbName + "." + this.tableName;
    }

    @Override
    public BaseLogEvent parseData(ByteBuffer buf) {
        this.tableId = UnsignedNumberHelper.convertLittleEndianLong(buf, 6);
        this.reserved = MysqlValueHelper.getFixedBytes(buf, 2);
        this.dbNameLength = (byte)UnsignedNumberHelper.convertLittleEndianUnsignedInt(buf, 1);
        this.dbName = UnsignedNumberHelper.convertByteArray2String(MysqlValueHelper.getFixedBytes(buf, this.dbNameLength));
        buf.get();
        this.tableNameLength = (byte)UnsignedNumberHelper.convertLittleEndianUnsignedInt(buf, 1);
        this.tableName = UnsignedNumberHelper.convertByteArray2String(MysqlValueHelper.getFixedBytes(buf, this.tableNameLength));
        buf.get();
        this.columnsLength = (int)MysqlValueHelper.convertLengthCodedLength(buf);
        this.columnInfoArray = new ColumnInfo[this.columnsLength];
        for (int i = 0; i < this.columnsLength; ++i) {
            ColumnInfo info;
            this.columnInfoArray[i] = info = new ColumnInfo();
            info.type = ColumnTypeEnum.getTypeEnumByValue((int)UnsignedNumberHelper.convertLittleEndianUnsignedInt(buf, 1));
        }
        int metaDataBlockLength = (int)MysqlValueHelper.convertLengthCodedLength(buf);
        byte[] metaBuf = new byte[metaDataBlockLength];
        buf.get(metaBuf);
        this.parseColumnMeta(metaBuf);
        this.fillNullBitMap(buf);
        if (null != this.callback) {
            this.callback.acceptTableMapEvent(this);
        }
        return this;
    }

    private void fillNullBitMap(ByteBuffer buf) {
        this.columnNullMap = new BitSet(this.columnsLength);
        int count = (this.columnsLength + 7) / 8;
        int index = 0;
        for (int i = 0; i < count; ++i) {
            byte val = buf.get();
            for (int j = 0; j < 8 && index < this.columnsLength; ++j, ++index) {
                if ((val & EventConstant.bitArray[j]) != EventConstant.bitArray[j]) continue;
                this.columnNullMap.set(index);
            }
        }
    }

    private void parseColumnMeta(byte[] buf) {
        ByteBuffer bbf = ByteBuffer.wrap(buf);
        for (ColumnInfo ci : this.columnInfoArray) {
            int byte0;
            if (ci.type.getMetaLen() > 0) {
                ci.meta = (int)UnsignedNumberHelper.convertLittleEndianUnsignedInt(bbf, ci.type.getMetaLen());
            }
            if (ci.type != ColumnTypeEnum.MYSQL_TYPE_STRING || ci.meta < 256 || ((byte0 = ci.meta & 0xFF) & 0x30) != 48 || byte0 == ColumnTypeEnum.MYSQL_TYPE_VAR_STRING.getTypeValue()) continue;
            try {
                ci.type = ColumnTypeEnum.getTypeEnumByValue(byte0);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
    }

    public static final class ColumnInfo {
        public ColumnTypeEnum type;
        public int meta;
    }
}

